/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network;

import com.nukkitx.protocol.bedrock.BedrockPong;
import com.nukkitx.protocol.bedrock.BedrockServerEventHandler;
import com.nukkitx.protocol.bedrock.BedrockServerSession;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.network.CIDRMatcher;
import org.geysermc.geyser.network.MinecraftProtocol;
import org.geysermc.geyser.network.QueryPacketHandler;
import org.geysermc.geyser.network.UpstreamPacketHandler;
import org.geysermc.geyser.ping.GeyserPingInfo;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.text.MessageTranslator;

public class ConnectorServerEventHandler
implements BedrockServerEventHandler {
    private static final boolean PRINT_DEBUG_PINGS = Boolean.parseBoolean(System.getProperty("Geyser.PrintPingsInDebugMode", "true"));
    private static final int MINECRAFT_VERSION_BYTES_LENGTH = MinecraftProtocol.DEFAULT_BEDROCK_CODEC.getMinecraftVersion().getBytes(StandardCharsets.UTF_8).length;
    private static final int BRAND_BYTES_LENGTH = "Geyser".getBytes(StandardCharsets.UTF_8).length;
    private static final int MAGIC_RAKNET_LENGTH = 338;
    private final GeyserImpl geyser;
    private final DefaultEventLoopGroup eventLoopGroup = new DefaultEventLoopGroup(0, new DefaultThreadFactory("Geyser player thread"));

    public ConnectorServerEventHandler(GeyserImpl geyser) {
        this.geyser = geyser;
    }

    @Override
    public boolean onConnectionRequest(InetSocketAddress inetSocketAddress) {
        List<String> allowedProxyIPs = this.geyser.getConfig().getBedrock().getProxyProtocolWhitelistedIPs();
        if (this.geyser.getConfig().getBedrock().isEnableProxyProtocol() && !allowedProxyIPs.isEmpty()) {
            boolean isWhitelistedIP = false;
            for (CIDRMatcher matcher : this.geyser.getConfig().getBedrock().getWhitelistedIPsMatchers()) {
                if (!matcher.matches(inetSocketAddress.getAddress())) continue;
                isWhitelistedIP = true;
                break;
            }
            if (!isWhitelistedIP) {
                return false;
            }
        }
        this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.attempt_connect", inetSocketAddress));
        return true;
    }

    @Override
    public BedrockPong onQuery(InetSocketAddress inetSocketAddress) {
        int subMotdLength;
        byte[] motdArray;
        if (this.geyser.getConfig().isDebugMode() && PRINT_DEBUG_PINGS) {
            this.geyser.getLogger().debug(GeyserLocale.getLocaleStringLog("geyser.network.pinged", inetSocketAddress));
        }
        GeyserConfiguration config = this.geyser.getConfig();
        GeyserPingInfo pingInfo = null;
        if (config.isPassthroughMotd() || config.isPassthroughPlayerCounts()) {
            IGeyserPingPassthrough pingPassthrough = this.geyser.getBootstrap().getGeyserPingPassthrough();
            pingInfo = pingPassthrough.getPingInformation(inetSocketAddress);
        }
        BedrockPong pong = new BedrockPong();
        pong.setEdition("MCPE");
        pong.setGameType("Survival");
        pong.setNintendoLimited(false);
        pong.setProtocolVersion(MinecraftProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion());
        pong.setVersion(MinecraftProtocol.DEFAULT_BEDROCK_CODEC.getMinecraftVersion());
        pong.setIpv4Port(config.getBedrock().getPort());
        if (config.isPassthroughMotd() && pingInfo != null && pingInfo.getDescription() != null) {
            String[] motd = MessageTranslator.convertMessageLenient(pingInfo.getDescription()).split("\n");
            String mainMotd = motd[0];
            String subMotd = motd.length != 1 ? motd[1] : "Geyser";
            pong.setMotd(mainMotd.trim());
            pong.setSubMotd(subMotd.trim());
        } else {
            pong.setMotd(config.getBedrock().getMotd1());
            pong.setSubMotd(config.getBedrock().getMotd2());
        }
        if (config.isPassthroughPlayerCounts() && pingInfo != null) {
            pong.setPlayerCount(pingInfo.getPlayers().getOnline());
            pong.setMaximumPlayerCount(pingInfo.getPlayers().getMax());
        } else {
            pong.setPlayerCount(this.geyser.getSessionManager().getSessions().size());
            pong.setMaximumPlayerCount(config.getMaxPlayers());
        }
        if (pong.getMotd() == null || pong.getMotd().isBlank()) {
            pong.setMotd("Geyser");
        }
        if (pong.getSubMotd() == null || pong.getSubMotd().isBlank()) {
            pong.setSubMotd("Geyser");
        }
        if ((motdArray = pong.getMotd().getBytes(StandardCharsets.UTF_8)).length + (subMotdLength = pong.getSubMotd().getBytes(StandardCharsets.UTF_8).length) > 338 - MINECRAFT_VERSION_BYTES_LENGTH) {
            if (subMotdLength > BRAND_BYTES_LENGTH) {
                pong.setSubMotd("Geyser");
                subMotdLength = BRAND_BYTES_LENGTH;
            }
            if (motdArray.length > 338 - MINECRAFT_VERSION_BYTES_LENGTH - subMotdLength) {
                byte[] newMotdArray = new byte[338 - MINECRAFT_VERSION_BYTES_LENGTH - subMotdLength];
                System.arraycopy(motdArray, 0, newMotdArray, 0, newMotdArray.length);
                pong.setMotd(new String(newMotdArray, StandardCharsets.UTF_8));
            }
        }
        if (pong.getPlayerCount() >= pong.getMaximumPlayerCount()) {
            pong.setMaximumPlayerCount(pong.getPlayerCount() + 1);
        }
        return pong;
    }

    @Override
    public void onSessionCreation(@Nonnull BedrockServerSession bedrockServerSession) {
        try {
            bedrockServerSession.setPacketCodec(MinecraftProtocol.DEFAULT_BEDROCK_CODEC);
            bedrockServerSession.setLogging(true);
            bedrockServerSession.setCompressionLevel(this.geyser.getConfig().getBedrock().getCompressionLevel());
            bedrockServerSession.setPacketHandler(new UpstreamPacketHandler(this.geyser, new GeyserSession(this.geyser, bedrockServerSession, this.eventLoopGroup.next())));
        }
        catch (Throwable e) {
            this.geyser.getLogger().error("Error occurred while initializing player!", e);
            bedrockServerSession.disconnect(e.getMessage());
        }
    }

    @Override
    public void onUnhandledDatagram(@Nonnull ChannelHandlerContext ctx, @Nonnull DatagramPacket packet) {
        block3: {
            try {
                ByteBuf content = (ByteBuf)packet.content();
                if (QueryPacketHandler.isQueryPacket(content)) {
                    new QueryPacketHandler(this.geyser, (InetSocketAddress)packet.sender(), content);
                }
            }
            catch (Throwable e) {
                if (!this.geyser.getConfig().isDebugMode()) break block3;
                this.geyser.getLogger().error("Error occurred during unhandled datagram!", e);
            }
        }
    }
}

