/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.physics;

import com.github.steveice10.mc.protocol.data.game.level.block.value.PistonValue;
import com.nukkitx.math.vector.Vector3i;
import javax.annotation.Nonnull;
import org.geysermc.geyser.level.physics.Axis;

public enum Direction {
    DOWN(1, Vector3i.from(0, -1, 0), Axis.Y, PistonValue.DOWN),
    UP(0, Vector3i.UNIT_Y, Axis.Y, PistonValue.UP),
    NORTH(3, Vector3i.from(0, 0, -1), Axis.Z, PistonValue.NORTH),
    SOUTH(2, Vector3i.UNIT_Z, Axis.Z, PistonValue.SOUTH),
    WEST(5, Vector3i.from(-1, 0, 0), Axis.X, PistonValue.WEST),
    EAST(4, Vector3i.UNIT_X, Axis.X, PistonValue.EAST);

    public static final Direction[] VALUES;
    private final int reversedId;
    private final Vector3i unitVector;
    private final Axis axis;
    private final PistonValue pistonValue;

    private Direction(int reversedId, Vector3i unitVector, Axis axis, PistonValue pistonValue) {
        this.reversedId = reversedId;
        this.unitVector = unitVector;
        this.axis = axis;
        this.pistonValue = pistonValue;
    }

    public Direction reversed() {
        return VALUES[this.reversedId];
    }

    public boolean isVertical() {
        return this.axis == Axis.Y;
    }

    public boolean isHorizontal() {
        return this.axis == Axis.X || this.axis == Axis.Z;
    }

    @Nonnull
    public static Direction fromPistonValue(PistonValue pistonValue) {
        for (Direction direction : VALUES) {
            if (direction.pistonValue != pistonValue) continue;
            return direction;
        }
        throw new IllegalStateException();
    }

    public Vector3i getUnitVector() {
        return this.unitVector;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public PistonValue getPistonValue() {
        return this.pistonValue;
    }

    static {
        VALUES = Direction.values();
    }
}

