/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block;

import com.nukkitx.network.util.Preconditions;

public class BlockPositionIterator {
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int sizeX;
    private final int sizeZ;
    private int i = 0;
    private final int maxI;

    public BlockPositionIterator(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        Preconditions.checkArgument(maxX >= minX, "maxX is not greater than or equal to minX");
        Preconditions.checkArgument(maxY >= minY, "maxY is not greater than or equal to minY");
        Preconditions.checkArgument(maxZ >= minZ, "maxZ is not greater than or equal to minZ");
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.sizeX = maxX - minX + 1;
        int sizeY = maxY - minY + 1;
        this.sizeZ = maxZ - minZ + 1;
        this.maxI = this.sizeX * sizeY * this.sizeZ;
    }

    public boolean hasNext() {
        return this.i < this.maxI;
    }

    public void next() {
        ++this.i;
    }

    public void reset() {
        this.i = 0;
    }

    public int getX() {
        return this.i / this.sizeZ % this.sizeX + this.minX;
    }

    public int getY() {
        return this.i / this.sizeZ / this.sizeX + this.minY;
    }

    public int getZ() {
        return this.i % this.sizeZ + this.minZ;
    }
}

