/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level;

import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.mc.protocol.data.game.setting.Difficulty;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtMapBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Locale;
import org.geysermc.geyser.level.GameRule;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.ChunkCache;
import org.geysermc.geyser.translator.inventory.LecternInventoryTranslator;

public class GeyserWorldManager
extends WorldManager {
    private static final Object2ObjectMap<String, String> gameruleCache = new Object2ObjectOpenHashMap();

    @Override
    public int getBlockAt(GeyserSession session, int x, int y, int z) {
        ChunkCache chunkCache = session.getChunkCache();
        if (chunkCache != null) {
            return chunkCache.getBlockAt(x, y, z);
        }
        return 0;
    }

    @Override
    public boolean hasOwnChunkCache() {
        return false;
    }

    @Override
    public NbtMap getLecternDataAt(GeyserSession session, int x, int y, int z, boolean isChunkLoad) {
        NbtMapBuilder lecternTag = LecternInventoryTranslator.getBaseLecternTag(x, y, z, 1);
        lecternTag.putCompound("book", NbtMap.builder().putByte("Count", (byte)1).putShort("Damage", (short)0).putString("Name", "minecraft:written_book").putCompound("tag", NbtMap.builder().putString("photoname", "").putString("text", "").build()).build());
        lecternTag.putInt("page", -1);
        return lecternTag.build();
    }

    @Override
    public boolean shouldExpectLecternHandled() {
        return false;
    }

    @Override
    public void setGameRule(GeyserSession session, String name, Object value) {
        session.sendCommand("gamerule " + name + " " + value);
        gameruleCache.put((Object)name, (Object)String.valueOf(value));
    }

    @Override
    public Boolean getGameRuleBool(GeyserSession session, GameRule gameRule) {
        String value = (String)gameruleCache.get((Object)gameRule.getJavaID());
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return gameRule.getDefaultValue() != null ? (Boolean)gameRule.getDefaultValue() : false;
    }

    @Override
    public int getGameRuleInt(GeyserSession session, GameRule gameRule) {
        String value = (String)gameruleCache.get((Object)gameRule.getJavaID());
        if (value != null) {
            return Integer.parseInt(value);
        }
        return gameRule.getDefaultValue() != null ? (Integer)gameRule.getDefaultValue() : 0;
    }

    @Override
    public void setPlayerGameMode(GeyserSession session, GameMode gameMode) {
        session.sendCommand("gamemode " + gameMode.name().toLowerCase(Locale.ROOT));
    }

    @Override
    public void setDifficulty(GeyserSession session, Difficulty difficulty) {
        session.sendCommand("difficulty " + difficulty.name().toLowerCase(Locale.ROOT));
    }

    @Override
    public boolean hasPermission(GeyserSession session, String permission) {
        return false;
    }
}

