/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level;

import com.github.steveice10.mc.protocol.data.game.advancement.Advancement;
import java.util.List;
import lombok.NonNull;
import org.geysermc.geyser.session.cache.AdvancementsCache;

public class GeyserAdvancement {
    private final Advancement advancement;
    private String rootId = null;

    public static GeyserAdvancement from(Advancement advancement) {
        return new GeyserAdvancement(advancement);
    }

    private GeyserAdvancement(Advancement advancement) {
        this.advancement = advancement;
    }

    @NonNull
    public String getId() {
        return this.advancement.getId();
    }

    @NonNull
    public List<String> getCriteria() {
        return this.advancement.getCriteria();
    }

    @NonNull
    public List<List<String>> getRequirements() {
        return this.advancement.getRequirements();
    }

    public String getParentId() {
        return this.advancement.getParentId();
    }

    public Advancement.DisplayData getDisplayData() {
        return this.advancement.getDisplayData();
    }

    public String getDisplayColor() {
        Advancement.DisplayData displayData = this.getDisplayData();
        return displayData != null && displayData.getFrameType() == Advancement.DisplayData.FrameType.CHALLENGE ? "\u00a7d" : "\u00a7a";
    }

    public String getRootId(AdvancementsCache advancementsCache) {
        if (this.rootId == null) {
            GeyserAdvancement advancement;
            this.rootId = this.advancement.getParentId() == null ? this.advancement.getId() : ((advancement = advancementsCache.getStoredAdvancements().get(this.advancement.getParentId())).getParentId() == null ? advancement.getId() : advancement.getRootId(advancementsCache));
        }
        return this.rootId;
    }
}

