/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level;

public enum GameRule {
    ANNOUNCEADVANCEMENTS("announceAdvancements", Boolean.class, true),
    COMMANDBLOCKOUTPUT("commandBlockOutput", Boolean.class, true),
    DISABLEELYTRAMOVEMENTCHECK("disableElytraMovementCheck", Boolean.class, false),
    DISABLERAIDS("disableRaids", Boolean.class, false),
    DODAYLIGHTCYCLE("doDaylightCycle", Boolean.class, true),
    DOENTITYDROPS("doEntityDrops", Boolean.class, true),
    DOFIRETICK("doFireTick", Boolean.class, true),
    DOIMMEDIATERESPAWN("doImmediateRespawn", Boolean.class, false),
    DOINSOMNIA("doInsomnia", Boolean.class, true),
    DOLIMITEDCRAFTING("doLimitedCrafting", Boolean.class, false),
    DOMOBLOOT("doMobLoot", Boolean.class, true),
    DOMOBSPAWNING("doMobSpawning", Boolean.class, true),
    DOPATROLSPAWNING("doPatrolSpawning", Boolean.class, true),
    DOTILEDROPS("doTileDrops", Boolean.class, true),
    DOTRADERSPAWNING("doTraderSpawning", Boolean.class, true),
    DOWEATHERCYCLE("doWeatherCycle", Boolean.class, true),
    DROWNINGDAMAGE("drowningDamage", Boolean.class, true),
    FALLDAMAGE("fallDamage", Boolean.class, true),
    FIREDAMAGE("fireDamage", Boolean.class, true),
    FREEZEDAMAGE("freezeDamage", Boolean.class, true),
    FORGIVEDEADPLAYERS("forgiveDeadPlayers", Boolean.class, true),
    KEEPINVENTORY("keepInventory", Boolean.class, false),
    LOGADMINCOMMANDS("logAdminCommands", Boolean.class, true),
    MAXCOMMANDCHAINLENGTH("maxCommandChainLength", Integer.class, 65536),
    MAXENTITYCRAMMING("maxEntityCramming", Integer.class, 24),
    MOBGRIEFING("mobGriefing", Boolean.class, true),
    NATURALREGENERATION("naturalRegeneration", Boolean.class, true),
    PLAYERSSLEEPINGPERCENTAGE("playersSleepingPercentage", Integer.class, 100),
    RANDOMTICKSPEED("randomTickSpeed", Integer.class, 3),
    REDUCEDDEBUGINFO("reducedDebugInfo", Boolean.class, false),
    SENDCOMMANDFEEDBACK("sendCommandFeedback", Boolean.class, true),
    SHOWDEATHMESSAGES("showDeathMessages", Boolean.class, true),
    SPAWNRADIUS("spawnRadius", Integer.class, 10),
    SPECTATORSGENERATECHUNKS("spectatorsGenerateChunks", Boolean.class, true),
    UNIVERSALANGER("universalAnger", Boolean.class, false),
    UNKNOWN("unknown", Object.class);

    public static final GameRule[] VALUES;
    private final String javaID;
    private final Class<?> type;
    private final Object defaultValue;

    private GameRule(String javaID, Class<?> type) {
        this(javaID, type, null);
    }

    private GameRule(String javaID, Class<?> type, Object defaultValue) {
        this.javaID = javaID;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public Object convertValue(String value) {
        if (this.type.equals(Boolean.class)) {
            return Boolean.parseBoolean(value);
        }
        if (this.type.equals(Integer.class)) {
            return Integer.parseInt(value);
        }
        return null;
    }

    public static GameRule fromJavaID(String id) {
        for (GameRule gamerule : VALUES) {
            if (!gamerule.javaID.equals(id)) continue;
            return gamerule;
        }
        return UNKNOWN;
    }

    public String getJavaID() {
        return this.javaID;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    static {
        VALUES = GameRule.values();
    }
}

