/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.updater;

import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundRenameItemPacket;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtMapBuilder;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.packet.InventorySlotPacket;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import java.util.Set;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.AnvilContainer;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.item.Enchantment;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.EnchantmentData;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.ItemUtils;

public class AnvilInventoryUpdater
extends InventoryUpdater {
    public static final AnvilInventoryUpdater INSTANCE = new AnvilInventoryUpdater();
    private static final int MAX_LEVEL_COST = 40;

    @Override
    public void updateInventory(InventoryTranslator translator, GeyserSession session, Inventory inventory) {
        super.updateInventory(translator, session, inventory);
        AnvilContainer anvilContainer = (AnvilContainer)inventory;
        this.updateInventoryState(session, anvilContainer);
        int targetSlot = this.getTargetSlot(session, anvilContainer);
        for (int i = 0; i < translator.size; ++i) {
            int bedrockSlot = translator.javaSlotToBedrock(i);
            if (bedrockSlot == 50) continue;
            if (i == targetSlot) {
                this.updateTargetSlot(translator, session, anvilContainer, targetSlot);
                continue;
            }
            InventorySlotPacket slotPacket = new InventorySlotPacket();
            slotPacket.setContainerId(124);
            slotPacket.setSlot(bedrockSlot);
            slotPacket.setItem(inventory.getItem(i).getItemData(session));
            session.sendUpstreamPacket(slotPacket);
        }
    }

    @Override
    public boolean updateSlot(InventoryTranslator translator, GeyserSession session, Inventory inventory, int javaSlot) {
        if (super.updateSlot(translator, session, inventory, javaSlot)) {
            return true;
        }
        AnvilContainer anvilContainer = (AnvilContainer)inventory;
        this.updateInventoryState(session, anvilContainer);
        int lastTargetSlot = anvilContainer.getLastTargetSlot();
        int targetSlot = this.getTargetSlot(session, anvilContainer);
        if (targetSlot != javaSlot) {
            InventorySlotPacket slotPacket = new InventorySlotPacket();
            slotPacket.setContainerId(124);
            slotPacket.setSlot(translator.javaSlotToBedrock(javaSlot));
            slotPacket.setItem(inventory.getItem(javaSlot).getItemData(session));
            session.sendUpstreamPacket(slotPacket);
        } else if (lastTargetSlot != javaSlot) {
            InventorySlotPacket slotPacket = new InventorySlotPacket();
            slotPacket.setContainerId(124);
            slotPacket.setSlot(translator.javaSlotToBedrock(lastTargetSlot));
            slotPacket.setItem(inventory.getItem(lastTargetSlot).getItemData(session));
            session.sendUpstreamPacket(slotPacket);
        }
        this.updateTargetSlot(translator, session, anvilContainer, targetSlot);
        return true;
    }

    private void updateInventoryState(GeyserSession session, AnvilContainer anvilContainer) {
        GeyserItemStack material;
        GeyserItemStack input = anvilContainer.getInput();
        if (!input.equals(anvilContainer.getLastInput())) {
            anvilContainer.setLastInput(input.copy());
            anvilContainer.setUseJavaLevelCost(false);
            String originalName = MessageTranslator.convertToPlainText(ItemUtils.getCustomName(input.getNbt()), session.getLocale());
            ServerboundRenameItemPacket renameItemPacket = new ServerboundRenameItemPacket(originalName);
            session.sendDownstreamPacket(renameItemPacket);
            anvilContainer.setNewName(null);
        }
        if (!(material = anvilContainer.getMaterial()).equals(anvilContainer.getLastMaterial())) {
            anvilContainer.setLastMaterial(material.copy());
            anvilContainer.setUseJavaLevelCost(false);
        }
    }

    private int getTargetSlot(GeyserSession session, AnvilContainer anvilContainer) {
        GeyserItemStack input = anvilContainer.getInput();
        GeyserItemStack material = anvilContainer.getMaterial();
        if (!material.isEmpty()) {
            if (!input.isEmpty() && this.isRepairing(session, input, material)) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    private void updateTargetSlot(InventoryTranslator translator, GeyserSession session, AnvilContainer anvilContainer, int slot) {
        ItemData itemData = anvilContainer.getItem(slot).getItemData(session);
        itemData = this.hijackRepairCost(session, anvilContainer, itemData);
        if (slot == 0 && this.isRenaming(session, anvilContainer, true)) {
            return;
        }
        anvilContainer.setLastTargetSlot(slot);
        InventorySlotPacket slotPacket = new InventorySlotPacket();
        slotPacket.setContainerId(124);
        slotPacket.setSlot(translator.javaSlotToBedrock(slot));
        slotPacket.setItem(itemData);
        session.sendUpstreamPacket(slotPacket);
    }

    private ItemData hijackRepairCost(GeyserSession session, AnvilContainer anvilContainer, ItemData itemData) {
        if (itemData.isNull()) {
            return itemData;
        }
        int newRepairCost = anvilContainer.isUseJavaLevelCost() ? anvilContainer.getJavaLevelCost() : this.calcLevelCost(session, anvilContainer, false);
        int bedrockLevelCost = this.calcLevelCost(session, anvilContainer, true);
        if (bedrockLevelCost == -1) {
            return itemData;
        }
        if ((newRepairCost -= bedrockLevelCost) == 0) {
            return itemData;
        }
        NbtMapBuilder tagBuilder = NbtMap.builder();
        if (itemData.getTag() != null) {
            newRepairCost += itemData.getTag().getInt("RepairCost", 0);
            tagBuilder.putAll(itemData.getTag());
        }
        tagBuilder.put("RepairCost", (Object)newRepairCost);
        return itemData.toBuilder().tag(tagBuilder.build()).build();
    }

    public int calcLevelCost(GeyserSession session, AnvilContainer anvilContainer, boolean bedrock) {
        GeyserItemStack input = anvilContainer.getInput();
        GeyserItemStack material = anvilContainer.getMaterial();
        if (input.isEmpty()) {
            return 0;
        }
        int totalRepairCost = this.getRepairCost(input);
        int cost = 0;
        if (!material.isEmpty()) {
            totalRepairCost += this.getRepairCost(material);
            if (this.isCombining(session, input, material)) {
                int enchantmentLevelCost;
                if (this.hasDurability(session, input) && input.getJavaId() == material.getJavaId()) {
                    cost += this.calcMergeRepairCost(session, input, material);
                }
                if ((enchantmentLevelCost = this.calcMergeEnchantmentCost(session, input, material, bedrock)) != -1) {
                    cost += enchantmentLevelCost;
                } else if (cost == 0) {
                    return -1;
                }
            } else if (this.hasDurability(session, input) && this.isRepairing(session, input, material)) {
                cost = this.calcRepairLevelCost(session, input, material);
                if (cost == -1) {
                    return -1;
                }
            } else {
                return -1;
            }
        }
        int totalCost = totalRepairCost + cost;
        if (this.isRenaming(session, anvilContainer, bedrock) && cost == 0 && ++totalCost >= 40) {
            totalCost = 39;
        }
        return totalCost;
    }

    private int calcRepairLevelCost(GeyserSession session, GeyserItemStack input, GeyserItemStack material) {
        int newDamage = this.getDamage(input);
        int unitRepair = Math.min(newDamage, input.getMapping(session).getMaxDamage() / 4);
        if (unitRepair <= 0) {
            return -1;
        }
        for (int i = 0; i < material.getAmount(); ++i) {
            if ((unitRepair = Math.min(newDamage -= unitRepair, input.getMapping(session).getMaxDamage() / 4)) > 0) continue;
            return i + 1;
        }
        return material.getAmount();
    }

    private int calcMergeRepairCost(GeyserSession session, GeyserItemStack input, GeyserItemStack material) {
        if (this.getDamage(input) > 0 && this.getDamage(material) < material.getMapping(session).getMaxDamage() * 112 / 100) {
            return 2;
        }
        return 0;
    }

    private int calcMergeEnchantmentCost(GeyserSession session, GeyserItemStack input, GeyserItemStack material, boolean bedrock) {
        boolean hasCompatible = false;
        Object2IntMap<Enchantment.JavaEnchantment> combinedEnchantments = this.getEnchantments(session, input, bedrock);
        int cost = 0;
        for (Object2IntMap.Entry entry : this.getEnchantments(session, material, bedrock).object2IntEntrySet()) {
            Enchantment.JavaEnchantment enchantment = (Enchantment.JavaEnchantment)((Object)entry.getKey());
            EnchantmentData data = (EnchantmentData)Registries.ENCHANTMENTS.get(enchantment);
            if (data == null) {
                GeyserImpl.getInstance().getLogger().debug("Java enchantment not in registry: " + enchantment);
                continue;
            }
            boolean canApply = this.isEnchantedBook(session, input) || data.validItems().contains(input.getJavaId());
            for (Enchantment.JavaEnchantment incompatible : data.incompatibleEnchantments()) {
                if (!combinedEnchantments.containsKey((Object)incompatible)) continue;
                canApply = false;
                if (bedrock) continue;
                ++cost;
            }
            if (!canApply && (bedrock || session.getGameMode() != GameMode.CREATIVE)) continue;
            int currentLevel = combinedEnchantments.getOrDefault((Object)enchantment, 0);
            int newLevel = entry.getIntValue();
            if (newLevel == currentLevel) {
                ++newLevel;
            }
            if ((newLevel = Math.max(currentLevel, newLevel)) > data.maxLevel()) {
                newLevel = data.maxLevel();
            }
            combinedEnchantments.put((Object)enchantment, newLevel);
            int rarityMultiplier = data.rarityMultiplier();
            if (this.isEnchantedBook(session, material) && rarityMultiplier > 1) {
                rarityMultiplier /= 2;
            }
            if (bedrock) {
                if (newLevel > currentLevel) {
                    hasCompatible = true;
                }
                if (enchantment == Enchantment.JavaEnchantment.IMPALING) {
                    rarityMultiplier /= 2;
                } else if (enchantment == Enchantment.JavaEnchantment.SWEEPING) {
                    rarityMultiplier = 0;
                }
                cost += rarityMultiplier * (newLevel - currentLevel);
                continue;
            }
            hasCompatible = true;
            cost += rarityMultiplier * newLevel;
        }
        if (!hasCompatible) {
            return -1;
        }
        return cost;
    }

    private Object2IntMap<Enchantment.JavaEnchantment> getEnchantments(GeyserSession session, GeyserItemStack itemStack, boolean bedrock) {
        if (itemStack.getNbt() == null) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap enchantments = new Object2IntOpenHashMap();
        Object enchantmentTag = this.isEnchantedBook(session, itemStack) ? itemStack.getNbt().get("StoredEnchantments") : itemStack.getNbt().get("Enchantments");
        Object object = enchantmentTag;
        if (object instanceof ListTag) {
            ListTag listTag = (ListTag)object;
            object = listTag.getValue().iterator();
            while (object.hasNext()) {
                Object object2;
                CompoundTag enchantTag;
                Object t2;
                Tag tag = (Tag)object.next();
                Tag tag2 = tag;
                if (!(tag2 instanceof CompoundTag) || !((t2 = (enchantTag = (CompoundTag)tag2).get("id")) instanceof StringTag)) continue;
                StringTag javaEnchId = (StringTag)t2;
                Enchantment.JavaEnchantment enchantment = Enchantment.JavaEnchantment.getByJavaIdentifier(javaEnchId.getValue());
                if (enchantment == null) {
                    GeyserImpl.getInstance().getLogger().debug("Unknown Java enchantment in anvil: " + javaEnchId.getValue());
                    continue;
                }
                Object javaEnchLvl = enchantTag.get("lvl");
                if (javaEnchLvl == null || !((object2 = ((Tag)javaEnchLvl).getValue()) instanceof Number)) continue;
                Number number = (Number)object2;
                if (bedrock) {
                    enchantments.putIfAbsent((Object)enchantment, number.intValue());
                    continue;
                }
                enchantments.mergeInt((Object)enchantment, number.intValue(), Math::max);
            }
        }
        return enchantments;
    }

    private boolean isEnchantedBook(GeyserSession session, GeyserItemStack itemStack) {
        return itemStack.getJavaId() == session.getItemMappings().getStoredItems().enchantedBook().getJavaId();
    }

    private boolean isCombining(GeyserSession session, GeyserItemStack input, GeyserItemStack material) {
        return this.isEnchantedBook(session, material) || input.getJavaId() == material.getJavaId() && this.hasDurability(session, input);
    }

    private boolean isRepairing(GeyserSession session, GeyserItemStack input, GeyserItemStack material) {
        Set<String> repairMaterials = input.getMapping(session).getRepairMaterials();
        return repairMaterials != null && repairMaterials.contains(material.getMapping(session).getJavaIdentifier());
    }

    private boolean isRenaming(GeyserSession session, AnvilContainer anvilContainer, boolean bedrock) {
        if (anvilContainer.getResult().isEmpty()) {
            return false;
        }
        String originalName = ItemUtils.getCustomName(anvilContainer.getInput().getNbt());
        if (bedrock && originalName != null && anvilContainer.getNewName() != null) {
            String legacyOriginalName = MessageTranslator.convertMessageLenient(originalName, session.getLocale());
            return !legacyOriginalName.equals(anvilContainer.getNewName());
        }
        return !Objects.equals(originalName, ItemUtils.getCustomName(anvilContainer.getResult().getNbt()));
    }

    private int getTagIntValueOr(GeyserItemStack itemStack, String tagName, int defaultValue) {
        Object object;
        Object tag;
        if (itemStack.getNbt() != null && (tag = itemStack.getNbt().get(tagName)) != null && (object = ((Tag)tag).getValue()) instanceof Number) {
            Number value = (Number)object;
            return value.intValue();
        }
        return defaultValue;
    }

    private int getRepairCost(GeyserItemStack itemStack) {
        return this.getTagIntValueOr(itemStack, "RepairCost", 0);
    }

    private boolean hasDurability(GeyserSession session, GeyserItemStack itemStack) {
        if (itemStack.getMapping(session).getMaxDamage() > 0) {
            return this.getTagIntValueOr(itemStack, "Unbreakable", 0) == 0;
        }
        return false;
    }

    private int getDamage(GeyserItemStack itemStack) {
        return this.getTagIntValueOr(itemStack, "Damage", 0);
    }
}

