/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.holder;

import com.google.common.collect.ImmutableSet;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.protocol.bedrock.data.inventory.ContainerType;
import com.nukkitx.protocol.bedrock.packet.BlockEntityDataPacket;
import com.nukkitx.protocol.bedrock.packet.ContainerClosePacket;
import com.nukkitx.protocol.bedrock.packet.ContainerOpenPacket;
import com.nukkitx.protocol.bedrock.packet.UpdateBlockPacket;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.holder.InventoryHolder;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.geyser.util.collection.Object2IntBiMap;

public class BlockInventoryHolder
extends InventoryHolder {
    private final int defaultJavaBlockState;
    private final ContainerType containerType;
    private final Set<String> validBlocks;

    public BlockInventoryHolder(String javaBlockIdentifier, ContainerType containerType, String ... validBlocks) {
        this.defaultJavaBlockState = (Integer)BlockRegistries.JAVA_IDENTIFIERS.get(javaBlockIdentifier);
        this.containerType = containerType;
        if (validBlocks != null) {
            HashSet<String> validBlocksTemp = new HashSet<String>(validBlocks.length + 1);
            Collections.addAll(validBlocksTemp, validBlocks);
            validBlocksTemp.add(BlockUtils.getCleanIdentifier(javaBlockIdentifier));
            this.validBlocks = ImmutableSet.copyOf(validBlocksTemp);
        } else {
            this.validBlocks = Collections.singleton(BlockUtils.getCleanIdentifier(javaBlockIdentifier));
        }
    }

    @Override
    public void prepareInventory(InventoryTranslator translator, GeyserSession session, Inventory inventory) {
        if (this.checkInteractionPosition(session)) {
            int javaBlockId = session.getGeyser().getWorldManager().getBlockAt(session, session.getLastInteractionBlockPosition());
            String[] javaBlockString = ((Object2IntBiMap)BlockRegistries.JAVA_IDENTIFIERS.get()).getOrDefault(javaBlockId, "minecraft:air").split("\\[");
            if (this.isValidBlock(javaBlockString)) {
                inventory.setHolderPosition(session.getLastInteractionBlockPosition());
                ((Container)inventory).setUsingRealBlock(true, javaBlockString[0]);
                this.setCustomName(session, session.getLastInteractionBlockPosition(), inventory, javaBlockId);
                return;
            }
        }
        Vector3i position = session.getPlayerEntity().getPosition().toInt();
        position = position.add(Vector3i.UP);
        UpdateBlockPacket blockPacket = new UpdateBlockPacket();
        blockPacket.setDataLayer(0);
        blockPacket.setBlockPosition(position);
        blockPacket.setRuntimeId(session.getBlockMappings().getBedrockBlockId(this.defaultJavaBlockState));
        blockPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket(blockPacket);
        inventory.setHolderPosition(position);
        this.setCustomName(session, position, inventory, this.defaultJavaBlockState);
    }

    protected boolean checkInteractionPosition(GeyserSession session) {
        return session.getLastInteractionPlayerPosition().equals(session.getPlayerEntity().getPosition());
    }

    protected boolean isValidBlock(String[] javaBlockString) {
        return this.validBlocks.contains(javaBlockString[0]);
    }

    protected void setCustomName(GeyserSession session, Vector3i position, Inventory inventory, int javaBlockState) {
        NbtMap tag = NbtMap.builder().putInt("x", position.getX()).putInt("y", position.getY()).putInt("z", position.getZ()).putString("CustomName", inventory.getTitle()).build();
        BlockEntityDataPacket dataPacket = new BlockEntityDataPacket();
        dataPacket.setData(tag);
        dataPacket.setBlockPosition(position);
        session.sendUpstreamPacket(dataPacket);
    }

    @Override
    public void openInventory(InventoryTranslator translator, GeyserSession session, Inventory inventory) {
        ContainerOpenPacket containerOpenPacket = new ContainerOpenPacket();
        containerOpenPacket.setId((byte)inventory.getId());
        containerOpenPacket.setType(this.containerType);
        containerOpenPacket.setBlockPosition(inventory.getHolderPosition());
        containerOpenPacket.setUniqueEntityId(inventory.getHolderId());
        session.sendUpstreamPacket(containerOpenPacket);
    }

    @Override
    public void closeInventory(InventoryTranslator translator, GeyserSession session, Inventory inventory) {
        if (((Container)inventory).isUsingRealBlock()) {
            ContainerClosePacket packet = new ContainerClosePacket();
            packet.setId((byte)inventory.getId());
            packet.setUnknownBool0(true);
            session.sendUpstreamPacket(packet);
            return;
        }
        Vector3i holderPos = inventory.getHolderPosition();
        int realBlock = session.getGeyser().getWorldManager().getBlockAt(session, holderPos.getX(), holderPos.getY(), holderPos.getZ());
        UpdateBlockPacket blockPacket = new UpdateBlockPacket();
        blockPacket.setDataLayer(0);
        blockPacket.setBlockPosition(holderPos);
        blockPacket.setRuntimeId(session.getBlockMappings().getBedrockBlockId(realBlock));
        blockPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket(blockPacket);
    }
}

