/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import javax.annotation.Nonnull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.session.GeyserSession;
import org.jetbrains.annotations.Range;

public class PlayerInventory
extends Inventory {
    private int heldItemSlot = 0;
    @Nonnull
    private GeyserItemStack cursor = GeyserItemStack.EMPTY;

    public PlayerInventory() {
        super(0, 46, null);
    }

    @Override
    public int getOffsetForHotbar(@Range(from=0L, to=8L) int slot) {
        return slot + 36;
    }

    public void setCursor(@Nonnull GeyserItemStack newCursor, GeyserSession session) {
        this.updateItemNetId(this.cursor, newCursor, session);
        this.cursor = newCursor;
    }

    public GeyserItemStack getItemInHand(@Nonnull Hand hand) {
        return hand == Hand.OFF_HAND ? this.getOffhand() : this.getItemInHand();
    }

    public GeyserItemStack getItemInHand() {
        if (36 + this.heldItemSlot > this.size) {
            GeyserImpl.getInstance().getLogger().debug("Held item slot was larger than expected!");
            return GeyserItemStack.EMPTY;
        }
        return this.items[36 + this.heldItemSlot];
    }

    public void setItemInHand(@Nonnull GeyserItemStack item) {
        if (36 + this.heldItemSlot > this.size) {
            GeyserImpl.getInstance().getLogger().debug("Held item slot was larger than expected!");
            return;
        }
        this.items[36 + this.heldItemSlot] = item;
    }

    public GeyserItemStack getOffhand() {
        return this.items[45];
    }

    public int getHeldItemSlot() {
        return this.heldItemSlot;
    }

    public void setHeldItemSlot(int heldItemSlot) {
        this.heldItemSlot = heldItemSlot;
    }

    @Nonnull
    public GeyserItemStack getCursor() {
        return this.cursor;
    }
}

