/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import com.github.steveice10.mc.protocol.data.game.inventory.ContainerType;
import com.github.steveice10.mc.protocol.data.game.inventory.VillagerTrade;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.inventory.ClientboundMerchantOffersPacket;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.session.GeyserSession;

public class MerchantContainer
extends Container {
    private Entity villager;
    private VillagerTrade[] villagerTrades;
    private ClientboundMerchantOffersPacket pendingOffersPacket;

    public MerchantContainer(String title, int id, int size, ContainerType containerType, PlayerInventory playerInventory) {
        super(title, id, size, containerType, playerInventory);
    }

    public void onTradeSelected(GeyserSession session, int slot) {
        if (this.villagerTrades != null && slot >= 0 && slot < this.villagerTrades.length) {
            VillagerTrade trade = this.villagerTrades[slot];
            this.setItem(2, GeyserItemStack.from(trade.getOutput()), session);
            session.getPlayerEntity().addFakeTradeExperience(trade.getXp());
            session.getPlayerEntity().updateBedrockMetadata();
        }
    }

    public Entity getVillager() {
        return this.villager;
    }

    public void setVillager(Entity villager) {
        this.villager = villager;
    }

    public void setVillagerTrades(VillagerTrade[] villagerTrades) {
        this.villagerTrades = villagerTrades;
    }

    public ClientboundMerchantOffersPacket getPendingOffersPacket() {
        return this.pendingOffersPacket;
    }

    public void setPendingOffersPacket(ClientboundMerchantOffersPacket pendingOffersPacket) {
        this.pendingOffersPacket = pendingOffersPacket;
    }
}

