/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import com.github.steveice10.mc.protocol.data.game.inventory.ContainerType;
import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.nukkitx.math.vector.Vector3i;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;
import org.jetbrains.annotations.Range;

public abstract class Inventory {
    protected final int id;
    private int stateId;
    private int nextStateId = -1;
    protected final int size;
    protected final ContainerType containerType;
    protected final String title;
    protected final GeyserItemStack[] items;
    protected Vector3i holderPosition = Vector3i.ZERO;
    protected long holderId = -1L;
    private boolean pending = false;

    protected Inventory(int id, int size, ContainerType containerType) {
        this("Inventory", id, size, containerType);
    }

    protected Inventory(String title, int id, int size, ContainerType containerType) {
        this.title = title;
        this.id = id;
        this.size = size;
        this.containerType = containerType;
        this.items = new GeyserItemStack[size];
        Arrays.fill(this.items, GeyserItemStack.EMPTY);
    }

    public GeyserItemStack getItem(int slot) {
        if (slot > this.size) {
            GeyserImpl.getInstance().getLogger().debug("Tried to get an item out of bounds! " + this);
            return GeyserItemStack.EMPTY;
        }
        return this.items[slot];
    }

    public abstract int getOffsetForHotbar(@Range(from=0L, to=8L) int var1);

    public void setItem(int slot, @Nonnull GeyserItemStack newItem, GeyserSession session) {
        Object lodestoneTag;
        CompoundTag nbt;
        if (slot > this.size) {
            session.getGeyser().getLogger().debug("Tried to set an item out of bounds! " + this);
            return;
        }
        GeyserItemStack oldItem = this.items[slot];
        this.updateItemNetId(oldItem, newItem, session);
        this.items[slot] = newItem;
        if (newItem.getJavaId() == session.getItemMappings().getStoredItems().compass().getJavaId() && (nbt = newItem.getNbt()) != null && (lodestoneTag = nbt.get("LodestoneTracked")) instanceof ByteTag) {
            session.getLodestoneCache().cacheInventoryItem(newItem);
        }
    }

    protected void updateItemNetId(GeyserItemStack oldItem, GeyserItemStack newItem, GeyserSession session) {
        if (!newItem.isEmpty()) {
            ItemMapping oldMapping = ItemTranslator.getBedrockItemMapping(session, oldItem);
            ItemMapping newMapping = ItemTranslator.getBedrockItemMapping(session, newItem);
            if (oldMapping.getBedrockId() == newMapping.getBedrockId()) {
                newItem.setNetId(oldItem.getNetId());
            } else {
                newItem.setNetId(session.getNextItemNetId());
            }
        }
    }

    public void incrementStateId(int count) {
        this.nextStateId = (this.nextStateId == -1 ? this.stateId : this.nextStateId) + count & Short.MAX_VALUE;
    }

    public void resetNextStateId() {
        this.nextStateId = -1;
    }

    public String toString() {
        return "Inventory(id=" + this.getId() + ", stateId=" + this.getStateId() + ", nextStateId=" + this.getNextStateId() + ", size=" + this.getSize() + ", containerType=" + this.getContainerType() + ", title=" + this.getTitle() + ", items=" + Arrays.deepToString(this.items) + ", holderPosition=" + this.getHolderPosition() + ", holderId=" + this.getHolderId() + ", pending=" + this.isPending() + ")";
    }

    public int getId() {
        return this.id;
    }

    public int getStateId() {
        return this.stateId;
    }

    public void setStateId(int stateId) {
        this.stateId = stateId;
    }

    public int getNextStateId() {
        return this.nextStateId;
    }

    public int getSize() {
        return this.size;
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public String getTitle() {
        return this.title;
    }

    public Vector3i getHolderPosition() {
        return this.holderPosition;
    }

    public void setHolderPosition(Vector3i holderPosition) {
        this.holderPosition = holderPosition;
    }

    public long getHolderId() {
        return this.holderId;
    }

    public void setHolderId(long holderId) {
        this.holderId = holderId;
    }

    public boolean isPending() {
        return this.pending;
    }

    public void setPending(boolean pending) {
        this.pending = pending;
    }
}

