/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import com.nukkitx.protocol.bedrock.data.inventory.EnchantData;
import com.nukkitx.protocol.bedrock.data.inventory.EnchantOptionData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geysermc.geyser.session.GeyserSession;

public class GeyserEnchantOption {
    private static final List<EnchantData> EMPTY = Collections.emptyList();
    private static final List<String> ENCHANT_NAMES = Arrays.asList("tougher armor", "lukeeey", "fall better", "explode less", "camo toy", "breathe better", "rtm five one six", "armor stab", "water walk", "you are elsa", "tim two zero three", "fast walk nether", "davchoo", "oof ouch owie", "enemy on fire", "spider sad", "aj ferguson", "redned", "more items thx", "long sword reach", "fast tool", "give me block", "less breaky break", "cube craft", "strong arrow", "fist arrow", "spicy arrow", "many many arrows", "geyser", "come here fish", "i like this", "stabby stab", "supreme mortal", "avatar i guess", "more arrows", "fly finder seventeen", "in and out", "xp heals tools", "dragon proxy waz here");
    private final int javaIndex;
    private boolean hasChanged;
    private int xpCost = 0;
    private int javaEnchantIndex = -1;
    private int bedrockEnchantIndex = -1;
    private int enchantLevel = -1;

    public GeyserEnchantOption(int javaIndex) {
        this.javaIndex = javaIndex;
    }

    public EnchantOptionData build(GeyserSession session) {
        this.hasChanged = false;
        return new EnchantOptionData(this.xpCost, this.javaIndex + 16, EMPTY, this.enchantLevel == -1 ? EMPTY : Collections.singletonList(new EnchantData(this.bedrockEnchantIndex, this.enchantLevel)), EMPTY, this.javaEnchantIndex == -1 ? "unknown" : ENCHANT_NAMES.get(this.javaEnchantIndex), this.enchantLevel == -1 ? 0 : session.getNextItemNetId());
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setXpCost(int xpCost) {
        if (this.xpCost != xpCost) {
            this.hasChanged = true;
            this.xpCost = xpCost;
        }
    }

    public void setEnchantIndex(int javaEnchantIndex, int bedrockEnchantIndex) {
        if (this.javaEnchantIndex != javaEnchantIndex) {
            this.hasChanged = true;
            this.javaEnchantIndex = javaEnchantIndex;
            this.bedrockEnchantIndex = bedrockEnchantIndex;
        }
    }

    public void setEnchantLevel(int enchantLevel) {
        if (this.enchantLevel != enchantLevel) {
            this.hasChanged = true;
            this.enchantLevel = enchantLevel;
        }
    }

    public int getJavaIndex() {
        return this.javaIndex;
    }
}

