/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.player;

import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.GameType;
import com.nukkitx.protocol.bedrock.data.PlayerPermission;
import com.nukkitx.protocol.bedrock.data.command.CommandPermission;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.packet.AddPlayerPacket;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.skin.SkullSkinManager;

public class SkullPlayerEntity
extends PlayerEntity {
    public SkullPlayerEntity(GeyserSession session, long geyserId) {
        super(session, 0, geyserId, UUID.randomUUID(), Vector3f.ZERO, Vector3f.ZERO, 0.0f, 0.0f, 0.0f, "", null);
        this.setPlayerList(false);
    }

    @Override
    protected void initializeMetadata() {
        this.dirtyMetadata.put(EntityData.SCALE, Float.valueOf(1.08f));
        this.dirtyMetadata.put(EntityData.BOUNDING_BOX_HEIGHT, Float.valueOf(0.001f));
        this.dirtyMetadata.put(EntityData.BOUNDING_BOX_WIDTH, Float.valueOf(0.001f));
        this.setFlag(EntityFlag.CAN_SHOW_NAME, false);
        this.setFlag(EntityFlag.INVISIBLE, true);
    }

    @Override
    public void spawnEntity() {
        AddPlayerPacket addPlayerPacket = new AddPlayerPacket();
        addPlayerPacket.setUuid(this.getUuid());
        addPlayerPacket.setUsername(this.getUsername());
        addPlayerPacket.setRuntimeEntityId(this.geyserId);
        addPlayerPacket.setUniqueEntityId(this.geyserId);
        addPlayerPacket.setPosition(this.position.sub(0.0f, this.definition.offset(), 0.0f));
        addPlayerPacket.setRotation(this.getBedrockRotation());
        addPlayerPacket.setMotion(this.motion);
        addPlayerPacket.setHand(this.hand);
        addPlayerPacket.getAdventureSettings().setCommandPermission(CommandPermission.NORMAL);
        addPlayerPacket.getAdventureSettings().setPlayerPermission(PlayerPermission.MEMBER);
        addPlayerPacket.setDeviceId("");
        addPlayerPacket.setPlatformChatId("");
        addPlayerPacket.setGameType(GameType.SURVIVAL);
        addPlayerPacket.setAbilityLayers(BASE_ABILITY_LAYER);
        addPlayerPacket.getMetadata().putFlags(this.flags);
        this.dirtyMetadata.apply(addPlayerPacket.getMetadata());
        this.setFlagsDirty(false);
        this.valid = true;
        this.session.sendUpstreamPacket(addPlayerPacket);
    }

    public void free() {
        this.setFlag(EntityFlag.INVISIBLE, true);
        this.updateBedrockMetadata();
        this.moveAbsolute(this.session.getPlayerEntity().getPosition().up(128.0f), 0.0f, 0.0f, 0.0f, false, true);
    }

    public void updateSkull(SkullCache.Skull skull) {
        float rotation;
        if (!skull.getTexturesProperty().equals(this.getTexturesProperty())) {
            this.setFlag(EntityFlag.INVISIBLE, true);
            this.updateBedrockMetadata();
            this.setTexturesProperty(skull.getTexturesProperty());
            SkullSkinManager.requestAndHandleSkin(this, this.session, skin -> this.session.scheduleInEventLoop(() -> {
                this.setFlag(EntityFlag.INVISIBLE, false);
                this.updateBedrockMetadata();
            }, 250L, TimeUnit.MILLISECONDS));
        } else {
            this.setFlag(EntityFlag.INVISIBLE, false);
            this.updateBedrockMetadata();
        }
        float x = (float)skull.getPosition().getX() + 0.5f;
        float y = (float)skull.getPosition().getY() - 0.01f;
        float z = (float)skull.getPosition().getZ() + 0.5f;
        int blockState = skull.getBlockState();
        byte floorRotation = BlockStateValues.getSkullRotation(blockState);
        if (floorRotation == -1) {
            y += 0.25f;
            rotation = BlockStateValues.getSkullWallDirections().get(blockState);
            switch ((int)rotation) {
                case 180: {
                    z += 0.24f;
                    break;
                }
                case 0: {
                    z -= 0.24f;
                    break;
                }
                case 90: {
                    x += 0.24f;
                    break;
                }
                case 270: {
                    x -= 0.24f;
                }
            }
        } else {
            rotation = (180.0f + (float)floorRotation * 22.5f) % 360.0f;
        }
        this.moveAbsolute(Vector3f.from(x, y, z), rotation, 0.0f, rotation, true, true);
    }
}

