/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.player;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Pose;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.FloatEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.scoreboard.ScoreboardPosition;
import com.github.steveice10.mc.protocol.data.game.scoreboard.TeamColor;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.data.Ability;
import com.nukkitx.protocol.bedrock.data.AbilityLayer;
import com.nukkitx.protocol.bedrock.data.AttributeData;
import com.nukkitx.protocol.bedrock.data.GameType;
import com.nukkitx.protocol.bedrock.data.PlayerPermission;
import com.nukkitx.protocol.bedrock.data.command.CommandPermission;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.data.entity.EntityLinkData;
import com.nukkitx.protocol.bedrock.packet.AddPlayerPacket;
import com.nukkitx.protocol.bedrock.packet.MovePlayerPacket;
import com.nukkitx.protocol.bedrock.packet.SetEntityDataPacket;
import com.nukkitx.protocol.bedrock.packet.SetEntityLinkPacket;
import com.nukkitx.protocol.bedrock.packet.UpdateAttributesPacket;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.LivingEntity;
import org.geysermc.geyser.entity.type.living.animal.tameable.ParrotEntity;
import org.geysermc.geyser.scoreboard.Objective;
import org.geysermc.geyser.scoreboard.Score;
import org.geysermc.geyser.scoreboard.Team;
import org.geysermc.geyser.scoreboard.UpdateType;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.relocate.kyori.adventure.text.Component;

public class PlayerEntity
extends LivingEntity {
    public static final float SNEAKING_POSE_HEIGHT = 1.5f;
    protected static final List<AbilityLayer> BASE_ABILITY_LAYER;
    private String username;
    private boolean playerList = true;
    @Nullable
    private String texturesProperty;
    private Vector3i bedPosition;
    private ParrotEntity leftParrot;
    private ParrotEntity rightParrot;

    public PlayerEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw, String username, @Nullable String texturesProperty) {
        super(session, entityId, geyserId, uuid, EntityDefinitions.PLAYER, position, motion, yaw, pitch, headYaw);
        this.username = username;
        this.texturesProperty = texturesProperty;
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityData.MARK_VARIANT, 255);
    }

    @Override
    public void spawnEntity() {
        Objective objective = this.session.getWorldCache().getScoreboard().getObjectiveSlots().get((Object)ScoreboardPosition.BELOW_NAME);
        if (objective != null) {
            this.setBelowNameText(objective);
        }
        this.updateDisplayName(null, false);
        AddPlayerPacket addPlayerPacket = new AddPlayerPacket();
        addPlayerPacket.setUuid(this.uuid);
        addPlayerPacket.setUsername(this.username);
        addPlayerPacket.setRuntimeEntityId(this.geyserId);
        addPlayerPacket.setUniqueEntityId(this.geyserId);
        addPlayerPacket.setPosition(this.position.sub(0.0f, this.definition.offset(), 0.0f));
        addPlayerPacket.setRotation(this.getBedrockRotation());
        addPlayerPacket.setMotion(this.motion);
        addPlayerPacket.setHand(this.hand);
        addPlayerPacket.getAdventureSettings().setCommandPermission(CommandPermission.NORMAL);
        addPlayerPacket.getAdventureSettings().setPlayerPermission(PlayerPermission.MEMBER);
        addPlayerPacket.setDeviceId("");
        addPlayerPacket.setPlatformChatId("");
        addPlayerPacket.setGameType(GameType.SURVIVAL);
        addPlayerPacket.setAbilityLayers(BASE_ABILITY_LAYER);
        addPlayerPacket.getMetadata().putFlags(this.flags);
        this.dirtyMetadata.apply(addPlayerPacket.getMetadata());
        this.setFlagsDirty(false);
        this.valid = true;
        this.session.sendUpstreamPacket(addPlayerPacket);
    }

    public void sendPlayer() {
        if (this.session.getEntityCache().getPlayerEntity(this.uuid) == null) {
            return;
        }
        if (this.session.getEntityCache().getEntityByGeyserId(this.geyserId) == null) {
            this.session.getEntityCache().spawnEntity(this);
        } else {
            this.spawnEntity();
        }
    }

    @Override
    public void moveAbsolute(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        this.setPosition(position);
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setHeadYaw(headYaw);
        this.setOnGround(isOnGround);
        MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
        movePlayerPacket.setRuntimeEntityId(this.geyserId);
        movePlayerPacket.setPosition(this.position);
        movePlayerPacket.setRotation(this.getBedrockRotation());
        movePlayerPacket.setOnGround(isOnGround);
        movePlayerPacket.setMode(teleported ? MovePlayerPacket.Mode.TELEPORT : MovePlayerPacket.Mode.NORMAL);
        if (teleported) {
            movePlayerPacket.setTeleportationCause(MovePlayerPacket.TeleportationCause.UNKNOWN);
        }
        this.session.sendUpstreamPacket(movePlayerPacket);
        if (teleported) {
            this.updateHeadLookRotation(headYaw);
        }
        if (this.leftParrot != null) {
            this.leftParrot.moveAbsolute(position, yaw, pitch, headYaw, true, teleported);
        }
        if (this.rightParrot != null) {
            this.rightParrot.moveAbsolute(position, yaw, pitch, headYaw, true, teleported);
        }
    }

    @Override
    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setHeadYaw(headYaw);
        this.position = Vector3f.from((double)this.position.getX() + relX, (double)this.position.getY() + relY, (double)this.position.getZ() + relZ);
        this.setOnGround(isOnGround);
        MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
        movePlayerPacket.setRuntimeEntityId(this.geyserId);
        movePlayerPacket.setPosition(this.position);
        movePlayerPacket.setRotation(this.getBedrockRotation());
        movePlayerPacket.setOnGround(isOnGround);
        movePlayerPacket.setMode(MovePlayerPacket.Mode.NORMAL);
        if (this.getFlag(EntityFlag.SLEEPING) && this.bedPosition != null && (this.bedPosition.getY() == 0 || this.bedPosition.distanceSquared(this.position.toInt()) > 4)) {
            movePlayerPacket.setPosition(Vector3f.from(this.position.getX(), this.position.getY() - this.definition.offset() + 0.2f, this.position.getZ()));
            movePlayerPacket.setMode(MovePlayerPacket.Mode.TELEPORT);
            movePlayerPacket.setTeleportationCause(MovePlayerPacket.TeleportationCause.UNKNOWN);
        }
        this.session.sendUpstreamPacket(movePlayerPacket);
        if (this.leftParrot != null) {
            this.leftParrot.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, true);
        }
        if (this.rightParrot != null) {
            this.rightParrot.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, true);
        }
    }

    public void updateRotation(float yaw, float pitch, float headYaw, boolean isOnGround) {
        this.moveRelative(0.0, 0.0, 0.0, yaw, pitch, headYaw, isOnGround);
    }

    @Override
    public void setPosition(Vector3f position) {
        super.setPosition(position.add(0.0f, this.definition.offset(), 0.0f));
    }

    @Override
    public Vector3i setBedPosition(EntityMetadata<Optional<Vector3i>, ?> entityMetadata) {
        this.bedPosition = super.setBedPosition(entityMetadata);
        return this.bedPosition;
    }

    public void setAbsorptionHearts(FloatEntityMetadata entityMetadata) {
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.geyserId);
        attributesPacket.setAttributes(Collections.singletonList(new AttributeData("minecraft:absorption", 0.0f, 1024.0f, entityMetadata.getPrimitiveValue(), 0.0f)));
        this.session.sendUpstreamPacket(attributesPacket);
    }

    public void setSkinVisibility(ByteEntityMetadata entityMetadata) {
        this.dirtyMetadata.put(EntityData.MARK_VARIANT, ~entityMetadata.getPrimitiveValue() & 0xFF);
    }

    public void setLeftParrot(EntityMetadata<CompoundTag, ?> entityMetadata) {
        this.setParrot(entityMetadata.getValue(), true);
    }

    public void setRightParrot(EntityMetadata<CompoundTag, ?> entityMetadata) {
        this.setParrot(entityMetadata.getValue(), false);
    }

    private void setParrot(CompoundTag tag, boolean isLeft) {
        if (tag != null && !tag.isEmpty()) {
            if (isLeft && this.leftParrot != null || !isLeft && this.rightParrot != null) {
                return;
            }
            ParrotEntity parrot = new ParrotEntity(this.session, 0, this.session.getEntityCache().getNextEntityId().incrementAndGet(), null, EntityDefinitions.PARROT, this.position, this.motion, this.getYaw(), this.getPitch(), this.getHeadYaw());
            parrot.spawnEntity();
            parrot.getDirtyMetadata().put(EntityData.VARIANT, ((Tag)tag.get("Variant")).getValue());
            float offset = isLeft ? 0.4f : -0.4f;
            parrot.getDirtyMetadata().put(EntityData.RIDER_SEAT_POSITION, Vector3f.from((double)offset, -0.22, -0.1));
            parrot.getDirtyMetadata().put(EntityData.RIDER_ROTATION_LOCKED, 1);
            parrot.updateBedrockMetadata();
            SetEntityLinkPacket linkPacket = new SetEntityLinkPacket();
            EntityLinkData.Type type = isLeft ? EntityLinkData.Type.RIDER : EntityLinkData.Type.PASSENGER;
            linkPacket.setEntityLink(new EntityLinkData(this.geyserId, parrot.getGeyserId(), type, false, false));
            this.session.scheduleInEventLoop(() -> this.session.sendUpstreamPacket(linkPacket), 500L, TimeUnit.MILLISECONDS);
            if (isLeft) {
                this.leftParrot = parrot;
            } else {
                this.rightParrot = parrot;
            }
        } else {
            ParrotEntity parrot;
            ParrotEntity parrotEntity = parrot = isLeft ? this.leftParrot : this.rightParrot;
            if (parrot != null) {
                parrot.despawnEntity();
                if (isLeft) {
                    this.leftParrot = null;
                } else {
                    this.rightParrot = null;
                }
            }
        }
    }

    @Override
    public void setDisplayName(EntityMetadata<Optional<Component>, ?> entityMetadata) {
    }

    public void updateDisplayName(@Nullable Team team, boolean useGivenTeam) {
        boolean needsUpdate;
        if (team == null && !useGivenTeam) {
            team = this.session.getWorldCache().getScoreboard().getTeamFor(this.username);
        }
        Object newDisplayName = this.username;
        if (team != null) {
            if (team.isVisibleFor(this.session.getPlayerEntity().getUsername())) {
                TeamColor color = team.getColor();
                String chatColor = MessageTranslator.toChatColor(color);
                String prefix = team.getCurrentData().getPrefix();
                String suffix = team.getCurrentData().getSuffix();
                newDisplayName = chatColor + prefix + chatColor + this.username + chatColor + suffix;
            } else {
                newDisplayName = "";
            }
            needsUpdate = useGivenTeam && !((String)newDisplayName).equals(this.nametag);
            this.nametag = newDisplayName;
            this.dirtyMetadata.put(EntityData.NAMETAG, newDisplayName);
        } else if (useGivenTeam) {
            needsUpdate = !((String)newDisplayName).equals(this.nametag);
            this.dirtyMetadata.put(EntityData.NAMETAG, this.username);
        } else {
            needsUpdate = false;
        }
        if (needsUpdate) {
            SetEntityDataPacket packet = new SetEntityDataPacket();
            packet.getMetadata().put(EntityData.NAMETAG, newDisplayName);
            packet.setRuntimeEntityId(this.geyserId);
            this.session.sendUpstreamPacket(packet);
        }
    }

    @Override
    public void setDisplayNameVisible(BooleanEntityMetadata entityMetadata) {
    }

    @Override
    protected void setDimensions(Pose pose) {
        float width;
        float height;
        switch (pose) {
            case SNEAKING: {
                height = 1.5f;
                width = this.definition.width();
                break;
            }
            case FALL_FLYING: 
            case SPIN_ATTACK: 
            case SWIMMING: {
                height = 0.6f;
                width = this.definition.width();
                break;
            }
            case DYING: {
                height = 0.2f;
                width = 0.2f;
                break;
            }
            default: {
                super.setDimensions(pose);
                return;
            }
        }
        this.setBoundingBoxWidth(width);
        this.setBoundingBoxHeight(height);
    }

    public void setBelowNameText(Objective objective) {
        if (objective != null && objective.getUpdateType() != UpdateType.REMOVE) {
            Score score = objective.getScores().get(this.username);
            int amount = score != null ? score.getCurrentData().getScore() : 0;
            String displayString = amount + " " + objective.getDisplayName();
            if (this.valid) {
                SetEntityDataPacket packet = new SetEntityDataPacket();
                packet.setRuntimeEntityId(this.geyserId);
                packet.getMetadata().put(EntityData.SCORE_TAG, (Object)displayString);
                this.session.sendUpstreamPacket(packet);
            }
        } else if (this.valid) {
            SetEntityDataPacket packet = new SetEntityDataPacket();
            packet.setRuntimeEntityId(this.geyserId);
            packet.getMetadata().put(EntityData.SCORE_TAG, (Object)"");
            this.session.sendUpstreamPacket(packet);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isPlayerList() {
        return this.playerList;
    }

    @Nullable
    public String getTexturesProperty() {
        return this.texturesProperty;
    }

    public Vector3i getBedPosition() {
        return this.bedPosition;
    }

    public ParrotEntity getLeftParrot() {
        return this.leftParrot;
    }

    public ParrotEntity getRightParrot() {
        return this.rightParrot;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPlayerList(boolean playerList) {
        this.playerList = playerList;
    }

    public void setTexturesProperty(@Nullable String texturesProperty) {
        this.texturesProperty = texturesProperty;
    }

    static {
        AbilityLayer abilityLayer = new AbilityLayer();
        abilityLayer.setLayerType(AbilityLayer.Type.BASE);
        Ability[] abilities = Ability.values();
        Collections.addAll(abilityLayer.getAbilitiesSet(), abilities);
        Collections.addAll(abilityLayer.getAbilityValues(), abilities);
        BASE_ABILITY_LAYER = Collections.singletonList(abilityLayer);
    }
}

