/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import java.util.UUID;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.monster.MonsterEntity;
import org.geysermc.geyser.session.GeyserSession;

public class WitherEntity
extends MonsterEntity {
    public WitherEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityData.WITHER_AERIAL_ATTACK, (short)1);
    }

    public void setTarget1(IntEntityMetadata entityMetadata) {
        this.setTargetId(EntityData.WITHER_TARGET_1, entityMetadata);
    }

    public void setTarget2(IntEntityMetadata entityMetadata) {
        this.setTargetId(EntityData.WITHER_TARGET_2, entityMetadata);
    }

    public void setTarget3(IntEntityMetadata entityMetadata) {
        this.setTargetId(EntityData.WITHER_TARGET_3, entityMetadata);
    }

    private void setTargetId(EntityData entityData, IntEntityMetadata entityMetadata) {
        int entityId = entityMetadata.getPrimitiveValue();
        Entity entity = this.session.getEntityCache().getEntityByJavaId(entityId);
        if (entity != null) {
            this.dirtyMetadata.put(entityData, entity.getGeyserId());
        } else {
            this.dirtyMetadata.put(entityData, 0L);
        }
    }

    public void setInvulnerableTicks(IntEntityMetadata entityMetadata) {
        int value = entityMetadata.getPrimitiveValue();
        this.dirtyMetadata.put(EntityData.WITHER_INVULNERABLE_TICKS, value);
        if (value >= 165) {
            this.dirtyMetadata.put(EntityData.WITHER_AERIAL_ATTACK, (short)0);
        } else {
            this.dirtyMetadata.put(EntityData.WITHER_AERIAL_ATTACK, (short)1);
        }
    }
}

