/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.tameable;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.google.common.collect.ImmutableSet;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.tameable.TameableEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.geyser.util.ItemUtils;

public class WolfEntity
extends TameableEntity {
    private static final Set<String> WOLF_FOODS = ImmutableSet.of((Object)"pufferfish", (Object)"tropical_fish", (Object)"chicken", (Object)"cooked_chicken", (Object)"porkchop", (Object)"beef", (Object[])new String[]{"rabbit", "cooked_porkchop", "cooked_beef", "rotten_flesh", "mutton", "cooked_mutton", "cooked_rabbit"});
    private byte collarColor;

    public WolfEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    public void setTameableFlags(ByteEntityMetadata entityMetadata) {
        boolean angry;
        super.setTameableFlags(entityMetadata);
        byte xd = entityMetadata.getPrimitiveValue();
        boolean bl = angry = (xd & 2) == 2;
        if (angry) {
            this.dirtyMetadata.put(EntityData.COLOR, (byte)0);
        }
    }

    public void setCollarColor(IntEntityMetadata entityMetadata) {
        this.collarColor = (byte)entityMetadata.getPrimitiveValue();
        if (this.getFlag(EntityFlag.ANGRY)) {
            return;
        }
        this.dirtyMetadata.put(EntityData.COLOR, this.collarColor);
        if (this.ownerBedrockId == 0L) {
            this.dirtyMetadata.put(EntityData.OWNER_EID, this.session.getPlayerEntity().getGeyserId());
        }
    }

    public void setWolfAngerTime(IntEntityMetadata entityMetadata) {
        int time = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.ANGRY, time != 0);
        this.dirtyMetadata.put(EntityData.COLOR, time != 0 ? (byte)0 : this.collarColor);
    }

    @Override
    public boolean canEat(String javaIdentifierStripped, ItemMapping mapping) {
        return WOLF_FOODS.contains(javaIdentifierStripped) && !this.isBaby();
    }

    @Override
    protected boolean canBeLeashed() {
        return !this.getFlag(EntityFlag.ANGRY) && super.canBeLeashed();
    }

    @Override
    @Nonnull
    protected InteractiveTag testMobInteraction(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (this.getFlag(EntityFlag.ANGRY)) {
            return InteractiveTag.NONE;
        }
        if (itemInHand.getMapping(this.session).getJavaIdentifier().equals("minecraft:bone") && !this.getFlag(EntityFlag.TAMED)) {
            return InteractiveTag.TAME;
        }
        int color = ItemUtils.dyeColorFor(itemInHand.getJavaId());
        if (color != -1) {
            if (color != this.collarColor) {
                return InteractiveTag.DYE;
            }
        } else if (this.getFlag(EntityFlag.TAMED) && this.ownerBedrockId == this.session.getPlayerEntity().getGeyserId()) {
            return this.getFlag(EntityFlag.SITTING) ? InteractiveTag.STAND : InteractiveTag.SIT;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    @Nonnull
    protected InteractionResult mobInteract(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (this.ownerBedrockId == this.session.getPlayerEntity().getGeyserId() || this.getFlag(EntityFlag.TAMED) || itemInHand.getMapping(this.session).getJavaIdentifier().equals("minecraft:bone") && !this.getFlag(EntityFlag.ANGRY)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }
}

