/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.tameable;

import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.tameable.TameableEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;

public class ParrotEntity
extends TameableEntity {
    public ParrotEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    public boolean canEat(String javaIdentifierStripped, ItemMapping mapping) {
        return false;
    }

    private boolean isTameFood(String javaIdentifierStripped) {
        return javaIdentifierStripped.contains("seeds");
    }

    private boolean isPoisonousFood(String javaIdentifierStripped) {
        return javaIdentifierStripped.equals("cookie");
    }

    @Override
    @Nonnull
    protected InteractiveTag testMobInteraction(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        String javaIdentifierStripped = itemInHand.getMapping(this.session).getJavaIdentifier().replace("minecraft:", "");
        boolean tame = this.getFlag(EntityFlag.TAMED);
        if (!tame && this.isTameFood(javaIdentifierStripped)) {
            return InteractiveTag.FEED;
        }
        if (this.isPoisonousFood(javaIdentifierStripped)) {
            return InteractiveTag.FEED;
        }
        if (this.onGround && tame && this.ownerBedrockId == this.session.getPlayerEntity().getGeyserId()) {
            return this.getFlag(EntityFlag.SITTING) ? InteractiveTag.STAND : InteractiveTag.SIT;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    @Nonnull
    protected InteractionResult mobInteract(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        String javaIdentifierStripped = itemInHand.getMapping(this.session).getJavaIdentifier().replace("minecraft:", "");
        boolean tame = this.getFlag(EntityFlag.TAMED);
        if (!tame && this.isTameFood(javaIdentifierStripped)) {
            return InteractionResult.SUCCESS;
        }
        if (this.isPoisonousFood(javaIdentifierStripped)) {
            return InteractionResult.SUCCESS;
        }
        if (this.onGround && tame && this.ownerBedrockId == this.session.getPlayerEntity().getGeyserId()) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(hand, itemInHand);
    }
}

