/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;

public class StriderEntity
extends AnimalEntity {
    private boolean isCold = false;

    public StriderEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.setFlag(EntityFlag.FIRE_IMMUNE, true);
        this.setFlag(EntityFlag.BREATHING, true);
    }

    public void setCold(BooleanEntityMetadata entityMetadata) {
        this.isCold = entityMetadata.getPrimitiveValue();
    }

    public void setSaddled(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.SADDLED, entityMetadata.getPrimitiveValue());
    }

    @Override
    public void updateBedrockMetadata() {
        if (this.getFlag(EntityFlag.RIDING)) {
            boolean parentShaking = false;
            if (this.vehicle instanceof StriderEntity) {
                parentShaking = this.vehicle.getFlag(EntityFlag.SHAKING);
            }
            this.setFlag(EntityFlag.BREATHING, !parentShaking);
            this.setFlag(EntityFlag.SHAKING, parentShaking);
        } else {
            this.setFlag(EntityFlag.BREATHING, !this.isCold);
            this.setFlag(EntityFlag.SHAKING, this.isShaking());
        }
        for (Entity passenger : this.passengers) {
            if (passenger == null) continue;
            passenger.updateBedrockMetadata();
        }
        super.updateBedrockMetadata();
    }

    @Override
    protected boolean isShaking() {
        return this.isCold || super.isShaking();
    }

    @Override
    public boolean canEat(String javaIdentifierStripped, ItemMapping mapping) {
        return javaIdentifierStripped.equals("warped_fungus");
    }

    @Override
    @Nonnull
    protected InteractiveTag testMobInteraction(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (!this.canEat(itemInHand) && this.getFlag(EntityFlag.SADDLED) && this.passengers.isEmpty() && !this.session.isSneaking()) {
            return InteractiveTag.RIDE_STRIDER;
        }
        InteractiveTag tag = super.testMobInteraction(hand, itemInHand);
        if (tag != InteractiveTag.NONE) {
            return tag;
        }
        return EntityUtils.attemptToSaddle(this.session, this, itemInHand).consumesAction() ? InteractiveTag.SADDLE : InteractiveTag.NONE;
    }

    @Override
    @Nonnull
    protected InteractionResult mobInteract(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (!this.canEat(itemInHand) && this.getFlag(EntityFlag.SADDLED) && this.passengers.isEmpty() && !this.session.isSneaking()) {
            return InteractionResult.SUCCESS;
        }
        InteractionResult superResult = super.mobInteract(hand, itemInHand);
        if (superResult.consumesAction()) {
            return superResult;
        }
        return EntityUtils.attemptToSaddle(this.session, this, itemInHand);
    }
}

