/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ObjectEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.item.StoredItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;

public class MooshroomEntity
extends AnimalEntity {
    private boolean isBrown = false;

    public MooshroomEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setVariant(ObjectEntityMetadata<String> entityMetadata) {
        this.isBrown = entityMetadata.getValue().equals("brown");
        this.dirtyMetadata.put(EntityData.VARIANT, this.isBrown ? 1 : 0);
    }

    @Override
    @Nonnull
    protected InteractiveTag testMobInteraction(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        StoredItemMappings storedItems = this.session.getItemMappings().getStoredItems();
        if (!this.isBaby()) {
            if (itemInHand.getJavaId() == storedItems.bowl()) {
                return InteractiveTag.MOOSHROOM_MILK_STEW;
            }
            if (this.isAlive() && itemInHand.getJavaId() == storedItems.shears()) {
                return InteractiveTag.MOOSHROOM_SHEAR;
            }
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    @Nonnull
    protected InteractionResult mobInteract(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        StoredItemMappings storedItems = this.session.getItemMappings().getStoredItems();
        boolean isBaby = this.isBaby();
        if (!isBaby && itemInHand.getJavaId() == storedItems.bowl()) {
            return InteractionResult.SUCCESS;
        }
        if (!isBaby && this.isAlive() && itemInHand.getJavaId() == storedItems.shears()) {
            return InteractionResult.SUCCESS;
        }
        if (this.isBrown && this.session.getTagCache().isSmallFlower(itemInHand) && itemInHand.getMapping(this.session).isHasSuspiciousStewEffect()) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(hand, itemInHand);
    }
}

