/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.geyser.util.InteractionResult;

public class AxolotlEntity
extends AnimalEntity {
    public AxolotlEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setVariant(IntEntityMetadata entityMetadata) {
        int variant = entityMetadata.getPrimitiveValue();
        switch (variant) {
            case 1: {
                variant = 3;
                break;
            }
            case 3: {
                variant = 1;
            }
        }
        this.dirtyMetadata.put(EntityData.VARIANT, variant);
    }

    public void setPlayingDead(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.PLAYING_DEAD, entityMetadata.getPrimitiveValue());
    }

    @Override
    public boolean canEat(String javaIdentifierStripped, ItemMapping mapping) {
        return this.session.getTagCache().isAxolotlTemptItem(mapping);
    }

    @Override
    protected short getMaxAir() {
        return 6000;
    }

    @Override
    protected boolean canBeLeashed() {
        return true;
    }

    @Override
    @Nonnull
    protected InteractionResult mobInteract(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (EntityUtils.attemptToBucket(this.session, itemInHand)) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(hand, itemInHand);
    }
}

