/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.GolemEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;

public class SnowGolemEntity
extends GolemEntity {
    public SnowGolemEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setSnowGolemFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.SHEARED, (xd & 0x10) != 16);
    }

    @Override
    @Nonnull
    protected InteractiveTag testMobInteraction(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (this.session.getItemMappings().getStoredItems().shears() == itemInHand.getJavaId() && this.isAlive() && !this.getFlag(EntityFlag.SHEARED)) {
            return InteractiveTag.SHEAR;
        }
        return InteractiveTag.NONE;
    }

    @Override
    @Nonnull
    protected InteractionResult mobInteract(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (this.session.getItemMappings().getStoredItems().shears() == itemInHand.getJavaId() && this.isAlive() && !this.getFlag(EntityFlag.SHEARED)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

