/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import java.util.UUID;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;

public class MinecartEntity
extends Entity {
    public MinecartEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position.add(0.0, (double)definition.offset(), 0.0), motion, yaw, pitch, headYaw);
    }

    public void setCustomBlock(IntEntityMetadata entityMetadata) {
        this.dirtyMetadata.put(EntityData.DISPLAY_ITEM, this.session.getBlockMappings().getBedrockBlockId(entityMetadata.getPrimitiveValue()));
    }

    public void setCustomBlockOffset(IntEntityMetadata entityMetadata) {
        this.dirtyMetadata.put(EntityData.DISPLAY_OFFSET, entityMetadata.getPrimitiveValue());
    }

    public void setShowCustomBlock(BooleanEntityMetadata entityMetadata) {
        this.dirtyMetadata.put(EntityData.CUSTOM_DISPLAY, (byte)(entityMetadata.getPrimitiveValue() ? 1 : 0));
    }

    @Override
    public void moveAbsolute(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        super.moveAbsolute(position.add(0.0, (double)this.definition.offset(), 0.0), yaw, pitch, headYaw, isOnGround, teleported);
    }

    @Override
    public Vector3f getBedrockRotation() {
        return Vector3f.from(0.0f, this.getYaw(), 0.0f);
    }

    @Override
    protected InteractiveTag testInteraction(Hand hand) {
        if (this.definition == EntityDefinitions.CHEST_MINECART || this.definition == EntityDefinitions.HOPPER_MINECART) {
            return InteractiveTag.OPEN_CONTAINER;
        }
        if (this.session.isSneaking()) {
            return InteractiveTag.NONE;
        }
        if (!this.passengers.isEmpty()) {
            return InteractiveTag.NONE;
        }
        return InteractiveTag.RIDE_MINECART;
    }

    @Override
    public InteractionResult interact(Hand hand) {
        if (this.definition == EntityDefinitions.CHEST_MINECART || this.definition == EntityDefinitions.HOPPER_MINECART) {
            return InteractionResult.SUCCESS;
        }
        if (this.session.isSneaking()) {
            return InteractionResult.PASS;
        }
        if (!this.passengers.isEmpty()) {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }
}

