/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import com.github.steveice10.mc.protocol.data.game.entity.attribute.Attribute;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.AttributeType;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Pose;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.FloatEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.data.AttributeData;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.packet.MobArmorEquipmentPacket;
import com.nukkitx.protocol.bedrock.packet.MobEquipmentPacket;
import com.nukkitx.protocol.bedrock.packet.UpdateAttributesPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.AttributeUtils;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.geyser.util.InteractionResult;

public class LivingEntity
extends Entity {
    protected ItemData helmet = ItemData.AIR;
    protected ItemData chestplate = ItemData.AIR;
    protected ItemData leggings = ItemData.AIR;
    protected ItemData boots = ItemData.AIR;
    protected ItemData hand = ItemData.AIR;
    protected ItemData offHand = ItemData.AIR;
    protected float health = 1.0f;
    protected float maxHealth = 20.0f;
    private boolean isMaxFrozenState = false;

    public LivingEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityData.HEALTH, 1);
    }

    public void setLivingEntityFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        boolean isUsingItem = (xd & 1) == 1;
        boolean isUsingOffhand = (xd & 2) == 2;
        ItemMapping shield = this.session.getItemMappings().getStoredItems().shield();
        boolean isUsingShield = this.hasShield(isUsingOffhand, shield);
        this.setFlag(EntityFlag.USING_ITEM, isUsingItem && !isUsingShield);
        this.setFlag(EntityFlag.BLOCKING, isUsingItem && isUsingShield);
        this.setFlag(EntityFlag.DAMAGE_NEARBY_MOBS, (xd & 4) == 4);
    }

    public void setHealth(FloatEntityMetadata entityMetadata) {
        this.health = entityMetadata.getPrimitiveValue();
        AttributeData healthData = this.createHealthAttribute();
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.geyserId);
        attributesPacket.setAttributes(Collections.singletonList(healthData));
        this.session.sendUpstreamPacket(attributesPacket);
    }

    public Vector3i setBedPosition(EntityMetadata<Optional<Vector3i>, ?> entityMetadata) {
        Optional<Vector3i> optionalPos = entityMetadata.getValue();
        if (optionalPos.isPresent()) {
            Vector3i bedPosition = optionalPos.get();
            this.dirtyMetadata.put(EntityData.BED_POSITION, bedPosition);
            int bed = this.session.getGeyser().getWorldManager().getBlockAt(this.session, bedPosition);
            ChunkUtils.updateBlock(this.session, bed, bedPosition);
            this.dirtyMetadata.put(EntityData.PLAYER_FLAGS, (byte)2);
            return bedPosition;
        }
        this.dirtyMetadata.put(EntityData.PLAYER_FLAGS, (byte)0);
        return null;
    }

    protected boolean hasShield(boolean offhand, ItemMapping shieldMapping) {
        if (offhand) {
            return this.offHand.getId() == shieldMapping.getBedrockId();
        }
        return this.hand.getId() == shieldMapping.getBedrockId();
    }

    @Override
    protected boolean isShaking() {
        return this.isMaxFrozenState;
    }

    @Override
    protected void setDimensions(Pose pose) {
        if (pose == Pose.SLEEPING) {
            this.setBoundingBoxWidth(0.2f);
            this.setBoundingBoxHeight(0.2f);
        } else {
            super.setDimensions(pose);
        }
    }

    @Override
    public float setFreezing(IntEntityMetadata entityMetadata) {
        float freezingPercentage = super.setFreezing(entityMetadata);
        this.isMaxFrozenState = freezingPercentage >= 1.0f;
        this.setFlag(EntityFlag.SHAKING, this.isShaking());
        return freezingPercentage;
    }

    protected AttributeData createHealthAttribute() {
        return new AttributeData(GeyserAttributeType.HEALTH.getBedrockIdentifier(), 0.0f, this.maxHealth, (float)Math.ceil(this.health), this.maxHealth);
    }

    @Override
    public boolean isAlive() {
        return this.valid && this.health > 0.0f;
    }

    @Override
    public InteractionResult interact(Hand hand) {
        InteractionResult result;
        GeyserItemStack itemStack = this.session.getPlayerInventory().getItemInHand(hand);
        if (itemStack.getJavaId() == this.session.getItemMappings().getStoredItems().nameTag() && (result = this.checkInteractWithNameTag(itemStack)).consumesAction()) {
            return result;
        }
        return super.interact(hand);
    }

    protected final InteractionResult checkInteractWithNameTag(GeyserItemStack itemStack) {
        CompoundTag displayTag;
        Object t2;
        CompoundTag nbt = itemStack.getNbt();
        if (nbt != null && (t2 = nbt.get("display")) instanceof CompoundTag && (displayTag = (CompoundTag)t2).get("Name") instanceof StringTag) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void updateArmor(GeyserSession session) {
        if (!this.valid) {
            return;
        }
        ItemData helmet = this.helmet;
        ItemData chestplate = this.chestplate;
        ItemMapping banner = session.getItemMappings().getStoredItems().banner();
        if (chestplate.getId() == ItemData.AIR.getId() && helmet.getId() == banner.getBedrockId()) {
            chestplate = this.helmet;
            helmet = ItemData.AIR;
        } else if (chestplate.getId() == banner.getBedrockId()) {
            chestplate = ItemData.AIR;
        }
        MobArmorEquipmentPacket armorEquipmentPacket = new MobArmorEquipmentPacket();
        armorEquipmentPacket.setRuntimeEntityId(this.geyserId);
        armorEquipmentPacket.setHelmet(helmet);
        armorEquipmentPacket.setChestplate(chestplate);
        armorEquipmentPacket.setLeggings(this.leggings);
        armorEquipmentPacket.setBoots(this.boots);
        session.sendUpstreamPacket(armorEquipmentPacket);
    }

    public void updateMainHand(GeyserSession session) {
        if (!this.valid) {
            return;
        }
        MobEquipmentPacket handPacket = new MobEquipmentPacket();
        handPacket.setRuntimeEntityId(this.geyserId);
        handPacket.setItem(this.hand);
        handPacket.setHotbarSlot(-1);
        handPacket.setInventorySlot(0);
        handPacket.setContainerId(0);
        session.sendUpstreamPacket(handPacket);
    }

    public void updateOffHand(GeyserSession session) {
        if (!this.valid) {
            return;
        }
        MobEquipmentPacket offHandPacket = new MobEquipmentPacket();
        offHandPacket.setRuntimeEntityId(this.geyserId);
        offHandPacket.setItem(this.offHand);
        offHandPacket.setHotbarSlot(-1);
        offHandPacket.setInventorySlot(0);
        offHandPacket.setContainerId(119);
        session.sendUpstreamPacket(offHandPacket);
    }

    public void updateBedrockAttributes(GeyserSession session, List<Attribute> attributes) {
        if (!this.valid) {
            return;
        }
        ArrayList<AttributeData> newAttributes = new ArrayList<AttributeData>();
        for (Attribute attribute : attributes) {
            this.updateAttribute(attribute, newAttributes);
        }
        if (newAttributes.isEmpty()) {
            return;
        }
        UpdateAttributesPacket updateAttributesPacket = new UpdateAttributesPacket();
        updateAttributesPacket.setRuntimeEntityId(this.geyserId);
        updateAttributesPacket.setAttributes(newAttributes);
        session.sendUpstreamPacket(updateAttributesPacket);
    }

    protected void updateAttribute(Attribute javaAttribute, List<AttributeData> newAttributes) {
        AttributeType attributeType = javaAttribute.getType();
        if (attributeType instanceof AttributeType.Builtin) {
            AttributeType.Builtin type = (AttributeType.Builtin)attributeType;
            switch (type) {
                case GENERIC_MAX_HEALTH: {
                    this.maxHealth = Math.max((float)AttributeUtils.calculateValue(javaAttribute), 1.0f);
                    newAttributes.add(this.createHealthAttribute());
                    break;
                }
                case GENERIC_ATTACK_DAMAGE: {
                    newAttributes.add(this.calculateAttribute(javaAttribute, GeyserAttributeType.ATTACK_DAMAGE));
                    break;
                }
                case GENERIC_FLYING_SPEED: {
                    newAttributes.add(this.calculateAttribute(javaAttribute, GeyserAttributeType.FLYING_SPEED));
                    break;
                }
                case GENERIC_MOVEMENT_SPEED: {
                    newAttributes.add(this.calculateAttribute(javaAttribute, GeyserAttributeType.MOVEMENT_SPEED));
                    break;
                }
                case GENERIC_FOLLOW_RANGE: {
                    newAttributes.add(this.calculateAttribute(javaAttribute, GeyserAttributeType.FOLLOW_RANGE));
                    break;
                }
                case GENERIC_KNOCKBACK_RESISTANCE: {
                    newAttributes.add(this.calculateAttribute(javaAttribute, GeyserAttributeType.KNOCKBACK_RESISTANCE));
                    break;
                }
                case HORSE_JUMP_STRENGTH: {
                    newAttributes.add(this.calculateAttribute(javaAttribute, GeyserAttributeType.HORSE_JUMP_STRENGTH));
                }
            }
        }
    }

    protected AttributeData calculateAttribute(Attribute javaAttribute, GeyserAttributeType type) {
        return type.getAttribute((float)AttributeUtils.calculateValue(javaAttribute));
    }

    public ItemData getHelmet() {
        return this.helmet;
    }

    public ItemData getChestplate() {
        return this.chestplate;
    }

    public ItemData getLeggings() {
        return this.leggings;
    }

    public ItemData getBoots() {
        return this.boots;
    }

    public ItemData getHand() {
        return this.hand;
    }

    public ItemData getOffHand() {
        return this.offHand;
    }

    public boolean isMaxFrozenState() {
        return this.isMaxFrozenState;
    }

    public void setHelmet(ItemData helmet) {
        this.helmet = helmet;
    }

    public void setChestplate(ItemData chestplate) {
        this.chestplate = chestplate;
    }

    public void setLeggings(ItemData leggings) {
        this.leggings = leggings;
    }

    public void setBoots(ItemData boots) {
        this.boots = boots;
    }

    public void setHand(ItemData hand) {
        this.hand = hand;
    }

    public void setOffHand(ItemData offHand) {
        this.offHand = offHand;
    }

    public void setMaxHealth(float maxHealth) {
        this.maxHealth = maxHealth;
    }

    public void setMaxFrozenState(boolean isMaxFrozenState) {
        this.isMaxFrozenState = isMaxFrozenState;
    }
}

