/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.object.Direction;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.github.steveice10.mc.protocol.data.game.entity.type.EntityType;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtMapBuilder;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.packet.BlockEntityDataPacket;
import com.nukkitx.protocol.bedrock.packet.UpdateBlockPacket;
import java.util.UUID;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InventoryUtils;

public class ItemFrameEntity
extends Entity {
    private final Vector3i bedrockPosition;
    private final int bedrockRuntimeId;
    private float rotation = 0.0f;
    private NbtMap cachedTag;
    private ItemStack heldItem = null;
    private boolean changed = true;

    public ItemFrameEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw, Direction direction) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        NbtMapBuilder blockBuilder = NbtMap.builder().putString("name", this.definition.entityType() == EntityType.GLOW_ITEM_FRAME ? "minecraft:glow_frame" : "minecraft:frame").putInt("version", session.getBlockMappings().getBlockStateVersion());
        NbtMapBuilder statesBuilder = NbtMap.builder().putInt("facing_direction", direction.ordinal()).putByte("item_frame_map_bit", (byte)0).putByte("item_frame_photo_bit", (byte)0);
        blockBuilder.put("states", (Object)statesBuilder.build());
        this.bedrockRuntimeId = session.getBlockMappings().getItemFrame(blockBuilder.build());
        this.bedrockPosition = Vector3i.from(position.getFloorX(), position.getFloorY(), position.getFloorZ());
        session.getItemFrameCache().put(this.bedrockPosition, this);
    }

    @Override
    protected void initializeMetadata() {
    }

    @Override
    public void spawnEntity() {
        this.updateBlock(true);
        this.session.getGeyser().getLogger().debug("Spawned item frame at location " + this.bedrockPosition + " with java id " + this.entityId);
        this.valid = true;
    }

    public void setItemInFrame(EntityMetadata<ItemStack, ?> entityMetadata) {
        if (entityMetadata.getValue() != null) {
            this.heldItem = entityMetadata.getValue();
            ItemData itemData = ItemTranslator.translateToBedrock(this.session, this.heldItem);
            ItemMapping mapping = this.session.getItemMappings().getMapping(entityMetadata.getValue());
            NbtMapBuilder builder = NbtMap.builder();
            builder.putByte("Count", (byte)itemData.getCount());
            if (itemData.getTag() != null) {
                builder.put("tag", (Object)itemData.getTag());
            }
            builder.putShort("Damage", (short)itemData.getDamage());
            builder.putString("Name", mapping.getBedrockIdentifier());
            NbtMapBuilder tag = this.getDefaultTag().toBuilder();
            tag.put("Item", (Object)builder.build());
            tag.putFloat("ItemDropChance", 1.0f);
            tag.putFloat("ItemRotation", this.rotation);
            this.cachedTag = tag.build();
            this.changed = true;
        } else if (this.cachedTag != null) {
            this.cachedTag = this.getDefaultTag();
            this.changed = true;
        }
    }

    public void setItemRotation(IntEntityMetadata entityMetadata) {
        this.rotation = entityMetadata.getPrimitiveValue() * 45;
        if (this.cachedTag == null) {
            return;
        }
        NbtMapBuilder builder = this.cachedTag.toBuilder();
        builder.putFloat("ItemRotation", this.rotation);
        this.cachedTag = builder.build();
        this.changed = true;
    }

    @Override
    public boolean despawnEntity() {
        UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
        updateBlockPacket.setDataLayer(0);
        updateBlockPacket.setBlockPosition(this.bedrockPosition);
        updateBlockPacket.setRuntimeId(this.session.getBlockMappings().getBedrockAirId());
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.PRIORITY);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NEIGHBORS);
        this.session.sendUpstreamPacket(updateBlockPacket);
        this.session.getItemFrameCache().remove(this.bedrockPosition, this);
        this.valid = false;
        return true;
    }

    private NbtMap getDefaultTag() {
        NbtMapBuilder builder = NbtMap.builder();
        builder.putInt("x", this.bedrockPosition.getX());
        builder.putInt("y", this.bedrockPosition.getY());
        builder.putInt("z", this.bedrockPosition.getZ());
        builder.putByte("isMovable", (byte)1);
        builder.putString("id", this.definition.entityType() == EntityType.GLOW_ITEM_FRAME ? "GlowItemFrame" : "ItemFrame");
        return builder.build();
    }

    @Override
    public void updateBedrockMetadata() {
        this.updateBlock(false);
    }

    public void updateBlock(boolean force) {
        if (!this.changed && !force) {
            return;
        }
        UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
        updateBlockPacket.setDataLayer(0);
        updateBlockPacket.setBlockPosition(this.bedrockPosition);
        updateBlockPacket.setRuntimeId(this.bedrockRuntimeId);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.PRIORITY);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NEIGHBORS);
        this.session.sendUpstreamPacket(updateBlockPacket);
        BlockEntityDataPacket blockEntityDataPacket = new BlockEntityDataPacket();
        blockEntityDataPacket.setBlockPosition(this.bedrockPosition);
        if (this.cachedTag != null) {
            blockEntityDataPacket.setData(this.cachedTag);
        } else {
            blockEntityDataPacket.setData(this.getDefaultTag());
        }
        this.session.sendUpstreamPacket(blockEntityDataPacket);
        this.changed = false;
    }

    @Override
    public InteractionResult interact(Hand hand) {
        return InventoryUtils.isEmpty(this.heldItem) && this.session.getPlayerInventory().getItemInHand(hand).isEmpty() ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    public static ItemFrameEntity getItemFrameEntity(GeyserSession session, Vector3i position) {
        return session.getItemFrameCache().get(position);
    }

    public ItemStack getHeldItem() {
        return this.heldItem;
    }
}

