/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtMapBuilder;
import com.nukkitx.nbt.NbtType;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.packet.SetEntityMotionPacket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.OptionalInt;
import java.util.UUID;
import org.geysermc.floodgate.util.DeviceOs;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.level.FireworkColor;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.MathUtils;

public class FireworkEntity
extends Entity {
    public FireworkEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setFireworkItem(EntityMetadata<ItemStack, ?> entityMetadata) {
        ItemStack item = entityMetadata.getValue();
        if (item == null) {
            return;
        }
        CompoundTag tag = item.getNbt();
        if (tag == null) {
            return;
        }
        if (this.session.getClientData().getDeviceOs() == DeviceOs.XBOX || this.session.getClientData().getDeviceOs() == DeviceOs.PS4) {
            return;
        }
        CompoundTag fireworks = (CompoundTag)tag.get("Fireworks");
        if (fireworks == null) {
            return;
        }
        NbtMapBuilder fireworksBuilder = NbtMap.builder();
        if (fireworks.get("Flight") != null) {
            fireworksBuilder.putByte("Flight", MathUtils.getNbtByte(((Tag)fireworks.get("Flight")).getValue()));
        }
        ArrayList<NbtMap> explosions = new ArrayList<NbtMap>();
        if (fireworks.get("Explosions") != null) {
            Iterator iterator = ((ListTag)fireworks.get("Explosions")).getValue().iterator();
            while (iterator.hasNext()) {
                int i;
                byte[] colors;
                int[] oldColors;
                Tag effect = (Tag)iterator.next();
                CompoundTag effectData = (CompoundTag)effect;
                NbtMapBuilder effectBuilder = NbtMap.builder();
                if (effectData.get("Type") != null) {
                    effectBuilder.putByte("FireworkType", MathUtils.getNbtByte(((Tag)effectData.get("Type")).getValue()));
                }
                if (effectData.get("Colors") != null) {
                    oldColors = (int[])((Tag)effectData.get("Colors")).getValue();
                    colors = new byte[oldColors.length];
                    i = 0;
                    for (int color : oldColors) {
                        colors[i++] = FireworkColor.fromJavaRGB(color);
                    }
                    effectBuilder.putByteArray("FireworkColor", colors);
                }
                if (effectData.get("FadeColors") != null) {
                    oldColors = (int[])((Tag)effectData.get("FadeColors")).getValue();
                    colors = new byte[oldColors.length];
                    i = 0;
                    for (int color : oldColors) {
                        colors[i++] = FireworkColor.fromJavaRGB(color);
                    }
                    effectBuilder.putByteArray("FireworkFade", colors);
                }
                if (effectData.get("Trail") != null) {
                    effectBuilder.putByte("FireworkTrail", MathUtils.getNbtByte(((Tag)effectData.get("Trail")).getValue()));
                }
                if (effectData.get("Flicker") != null) {
                    effectBuilder.putByte("FireworkFlicker", MathUtils.getNbtByte(((Tag)effectData.get("Flicker")).getValue()));
                }
                explosions.add(effectBuilder.build());
            }
        }
        fireworksBuilder.putList("Explosions", NbtType.COMPOUND, explosions);
        NbtMapBuilder builder = NbtMap.builder();
        builder.put("Fireworks", (Object)fireworksBuilder.build());
        this.dirtyMetadata.put(EntityData.DISPLAY_ITEM, builder.build());
    }

    public void setPlayerGliding(EntityMetadata<OptionalInt, ?> entityMetadata) {
        OptionalInt optional = entityMetadata.getValue();
        if (optional.isPresent() && optional.getAsInt() == this.session.getPlayerEntity().getEntityId()) {
            SessionPlayerEntity entity = this.session.getPlayerEntity();
            float yaw = entity.getYaw();
            float pitch = entity.getPitch();
            entity.setMotion(Vector3f.from(-Math.sin(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch)) * 2.0, -Math.sin(Math.toRadians(pitch)) * 2.0, Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch)) * 2.0));
            SetEntityMotionPacket entityMotionPacket = new SetEntityMotionPacket();
            entityMotionPacket.setRuntimeEntityId(entity.getGeyserId());
            entityMotionPacket.setMotion(entity.getMotion());
            this.session.sendUpstreamPacket(entityMotionPacket);
        }
    }
}

