/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Pose;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.github.steveice10.mc.protocol.data.game.entity.type.EntityType;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityEventType;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlags;
import com.nukkitx.protocol.bedrock.packet.AddEntityPacket;
import com.nukkitx.protocol.bedrock.packet.EntityEventPacket;
import com.nukkitx.protocol.bedrock.packet.MoveEntityAbsolutePacket;
import com.nukkitx.protocol.bedrock.packet.RemoveEntityPacket;
import com.nukkitx.protocol.bedrock.packet.SetEntityDataPacket;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.GeyserDirtyMetadata;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.relocate.kyori.adventure.text.Component;

public class Entity {
    protected final GeyserSession session;
    protected int entityId;
    protected final long geyserId;
    protected UUID uuid;
    protected Vector3f position;
    protected Vector3f motion;
    protected float yaw;
    protected float pitch;
    protected float headYaw;
    protected boolean onGround;
    protected EntityDefinition<?> definition;
    protected boolean valid;
    private float boundingBoxHeight;
    private float boundingBoxWidth;
    protected String nametag = "";
    protected boolean silent = false;
    protected List<Entity> passengers = Collections.emptyList();
    protected Entity vehicle;
    protected final GeyserDirtyMetadata dirtyMetadata = new GeyserDirtyMetadata();
    protected final EntityFlags flags = new EntityFlags();
    private boolean flagsDirty = false;

    public Entity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        this.session = session;
        this.entityId = entityId;
        this.geyserId = geyserId;
        this.uuid = uuid;
        this.definition = definition;
        this.motion = motion;
        this.yaw = yaw;
        this.pitch = pitch;
        this.headYaw = headYaw;
        this.valid = false;
        this.setPosition(position);
        this.setAirSupply(this.getMaxAir());
        this.initializeMetadata();
    }

    protected void initializeMetadata() {
        this.dirtyMetadata.put(EntityData.SCALE, Float.valueOf(1.0f));
        this.dirtyMetadata.put(EntityData.COLOR, (byte)0);
        this.dirtyMetadata.put(EntityData.MAX_AIR_SUPPLY, this.getMaxAir());
        this.setDimensions(Pose.STANDING);
        this.setFlag(EntityFlag.HAS_GRAVITY, true);
        this.setFlag(EntityFlag.HAS_COLLISION, true);
        this.setFlag(EntityFlag.CAN_SHOW_NAME, true);
        this.setFlag(EntityFlag.CAN_CLIMB, true);
        this.setClientSideSilent();
    }

    protected void setClientSideSilent() {
        this.setFlag(EntityFlag.SILENT, true);
    }

    public void spawnEntity() {
        AddEntityPacket addEntityPacket = new AddEntityPacket();
        addEntityPacket.setIdentifier(this.definition.identifier());
        addEntityPacket.setRuntimeEntityId(this.geyserId);
        addEntityPacket.setUniqueEntityId(this.geyserId);
        addEntityPacket.setPosition(this.position);
        addEntityPacket.setMotion(this.motion);
        addEntityPacket.setRotation(this.getBedrockRotation());
        addEntityPacket.getMetadata().putFlags(this.flags);
        this.dirtyMetadata.apply(addEntityPacket.getMetadata());
        this.addAdditionalSpawnData(addEntityPacket);
        this.valid = true;
        this.session.sendUpstreamPacket(addEntityPacket);
        this.flagsDirty = false;
        if (this.session.getGeyser().getConfig().isDebugMode()) {
            EntityType type = this.definition.entityType();
            String name = type != null ? type.name() : this.getClass().getSimpleName();
            this.session.getGeyser().getLogger().debug("Spawned entity " + name + " at location " + this.position + " with id " + this.geyserId + " (java id " + this.entityId + ")");
        }
    }

    public void addAdditionalSpawnData(AddEntityPacket addEntityPacket) {
    }

    public boolean despawnEntity() {
        if (!this.valid) {
            return true;
        }
        for (Entity passenger : this.passengers) {
            if (passenger == null) continue;
            passenger.setVehicle(null);
            passenger.setFlag(EntityFlag.RIDING, false);
            passenger.updateBedrockMetadata();
        }
        RemoveEntityPacket removeEntityPacket = new RemoveEntityPacket();
        removeEntityPacket.setUniqueEntityId(this.geyserId);
        this.session.sendUpstreamPacket(removeEntityPacket);
        this.valid = false;
        return true;
    }

    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, boolean isOnGround) {
        this.moveRelative(relX, relY, relZ, yaw, pitch, this.getHeadYaw(), isOnGround);
    }

    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setHeadYaw(headYaw);
        this.setOnGround(isOnGround);
        this.position = Vector3f.from((double)this.position.getX() + relX, (double)this.position.getY() + relY, (double)this.position.getZ() + relZ);
        MoveEntityAbsolutePacket moveEntityPacket = new MoveEntityAbsolutePacket();
        moveEntityPacket.setRuntimeEntityId(this.geyserId);
        moveEntityPacket.setPosition(this.position);
        moveEntityPacket.setRotation(this.getBedrockRotation());
        moveEntityPacket.setOnGround(isOnGround);
        moveEntityPacket.setTeleported(false);
        this.session.sendUpstreamPacket(moveEntityPacket);
    }

    public void moveAbsolute(Vector3f position, float yaw, float pitch, boolean isOnGround, boolean teleported) {
        this.moveAbsolute(position, yaw, pitch, this.getHeadYaw(), isOnGround, teleported);
    }

    public void moveAbsolute(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        this.setPosition(position);
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setHeadYaw(headYaw);
        this.setOnGround(isOnGround);
        MoveEntityAbsolutePacket moveEntityPacket = new MoveEntityAbsolutePacket();
        moveEntityPacket.setRuntimeEntityId(this.geyserId);
        moveEntityPacket.setPosition(position);
        moveEntityPacket.setRotation(this.getBedrockRotation());
        moveEntityPacket.setOnGround(isOnGround);
        moveEntityPacket.setTeleported(teleported);
        this.session.sendUpstreamPacket(moveEntityPacket);
    }

    public void teleport(Vector3f position, float yaw, float pitch, boolean isOnGround) {
        this.moveAbsolute(position, yaw, pitch, yaw, isOnGround, false);
    }

    public void updateHeadLookRotation(float headYaw) {
        this.moveRelative(0.0, 0.0, 0.0, this.getYaw(), this.getPitch(), headYaw, this.isOnGround());
    }

    public void updatePositionAndRotation(double moveX, double moveY, double moveZ, float yaw, float pitch, boolean isOnGround) {
        this.moveRelative(moveX, moveY, moveZ, yaw, pitch, this.getHeadYaw(), isOnGround);
    }

    public void updateRotation(float yaw, float pitch, boolean isOnGround) {
        this.updatePositionAndRotation(0.0, 0.0, 0.0, yaw, pitch, isOnGround);
    }

    public final boolean getFlag(EntityFlag flag) {
        return this.flags.getFlag(flag);
    }

    public final void setFlag(EntityFlag flag, boolean value) {
        this.flagsDirty |= this.flags.setFlag(flag, value);
    }

    public void updateBedrockMetadata() {
        if (!this.valid) {
            return;
        }
        if (this.dirtyMetadata.hasEntries() || this.flagsDirty) {
            SetEntityDataPacket entityDataPacket = new SetEntityDataPacket();
            entityDataPacket.setRuntimeEntityId(this.geyserId);
            if (this.flagsDirty) {
                entityDataPacket.getMetadata().putFlags(this.flags);
                this.flagsDirty = false;
            }
            this.dirtyMetadata.apply(entityDataPacket.getMetadata());
            this.session.sendUpstreamPacket(entityDataPacket);
        }
    }

    public void setFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.ON_FIRE, (xd & 1) == 1 && !this.getFlag(EntityFlag.FIRE_IMMUNE));
        this.setFlag(EntityFlag.SNEAKING, (xd & 2) == 2);
        this.setFlag(EntityFlag.SPRINTING, (xd & 8) == 8);
        this.setFlag(EntityFlag.GLIDING, (xd & 0x80) == 128);
        this.setInvisible((xd & 0x20) == 32);
    }

    protected void setInvisible(boolean value) {
        this.setFlag(EntityFlag.INVISIBLE, value);
    }

    public final void setAir(IntEntityMetadata entityMetadata) {
        this.setAirSupply(entityMetadata.getPrimitiveValue());
    }

    protected void setAirSupply(int amount) {
        this.dirtyMetadata.put(EntityData.AIR_SUPPLY, (short)MathUtils.constrain(amount, 0, this.getMaxAir()));
    }

    protected short getMaxAir() {
        return 300;
    }

    public void setDisplayName(EntityMetadata<Optional<Component>, ?> entityMetadata) {
        Optional<Component> name = entityMetadata.getValue();
        if (name.isPresent()) {
            this.nametag = MessageTranslator.convertMessage(name.get(), this.session.getLocale());
            this.dirtyMetadata.put(EntityData.NAMETAG, this.nametag);
        } else if (!this.nametag.isEmpty()) {
            this.dirtyMetadata.put(EntityData.NAMETAG, "");
        }
    }

    public void setDisplayNameVisible(BooleanEntityMetadata entityMetadata) {
        this.dirtyMetadata.put(EntityData.NAMETAG_ALWAYS_SHOW, (byte)(entityMetadata.getPrimitiveValue() ? 1 : 0));
    }

    public final void setSilent(BooleanEntityMetadata entityMetadata) {
        this.silent = entityMetadata.getPrimitiveValue();
    }

    public void setGravity(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.HAS_GRAVITY, !entityMetadata.getPrimitiveValue());
    }

    public void setPose(Pose pose) {
        this.setFlag(EntityFlag.SLEEPING, pose.equals((Object)Pose.SLEEPING));
        this.setFlag(EntityFlag.SWIMMING, pose.equals((Object)Pose.SWIMMING));
        this.setDimensions(pose);
    }

    protected void setDimensions(Pose pose) {
        this.setBoundingBoxHeight(this.definition.height());
        this.setBoundingBoxWidth(this.definition.width());
    }

    public boolean setBoundingBoxHeight(float height) {
        if (height != this.boundingBoxHeight) {
            this.boundingBoxHeight = height;
            this.dirtyMetadata.put(EntityData.BOUNDING_BOX_HEIGHT, Float.valueOf(this.boundingBoxHeight));
            this.updatePassengerOffsets();
            return true;
        }
        return false;
    }

    public void setBoundingBoxWidth(float width) {
        if (width != this.boundingBoxWidth) {
            this.boundingBoxWidth = width;
            this.dirtyMetadata.put(EntityData.BOUNDING_BOX_WIDTH, Float.valueOf(this.boundingBoxWidth));
        }
    }

    public float setFreezing(IntEntityMetadata entityMetadata) {
        int freezingTicks = Math.min(entityMetadata.getPrimitiveValue(), 140);
        float freezingPercentage = (float)freezingTicks / 140.0f;
        this.dirtyMetadata.put(EntityData.FREEZING_EFFECT_STRENGTH, Float.valueOf(freezingPercentage));
        return freezingPercentage;
    }

    public void setRiderSeatPosition(Vector3f position) {
        this.dirtyMetadata.put(EntityData.RIDER_SEAT_POSITION, position);
    }

    protected boolean isShaking() {
        return false;
    }

    public Vector3f getBedrockRotation() {
        return Vector3f.from(this.getPitch(), this.getYaw(), this.getHeadYaw());
    }

    protected void updatePassengerOffsets() {
        for (Entity passenger : this.passengers) {
            if (passenger == null) continue;
            boolean rider = this.passengers.get(0) == this;
            EntityUtils.updateMountOffset(passenger, this, rider, true, this.passengers.size() > 1);
            passenger.updateBedrockMetadata();
        }
    }

    protected void updateMountOffset() {
        if (this.vehicle != null) {
            boolean rider = this.vehicle.getPassengers().get(0) == this;
            EntityUtils.updateMountOffset(this, this.vehicle, rider, true, this.vehicle.getPassengers().size() > 1);
            this.updateBedrockMetadata();
        }
    }

    public boolean isAlive() {
        return this.valid;
    }

    public final void updateInteractiveTag() {
        Hand hand;
        InteractiveTag tag = InteractiveTag.NONE;
        Hand[] handArray = EntityUtils.HANDS;
        int n = handArray.length;
        for (int i = 0; i < n && (tag = this.testInteraction(hand = handArray[i])) == InteractiveTag.NONE; ++i) {
        }
        this.session.getPlayerEntity().getDirtyMetadata().put(EntityData.INTERACTIVE_TAG, tag.getValue());
        this.session.getPlayerEntity().updateBedrockMetadata();
    }

    protected InteractiveTag testInteraction(Hand hand) {
        return InteractiveTag.NONE;
    }

    public InteractionResult interact(Hand hand) {
        return InteractionResult.PASS;
    }

    public InteractionResult interactAt(Hand hand) {
        return InteractionResult.PASS;
    }

    public final void playEntityEvent(EntityEventType type) {
        this.playEntityEvent(type, 0);
    }

    public final void playEntityEvent(EntityEventType type, int data) {
        EntityEventPacket packet = new EntityEventPacket();
        packet.setRuntimeEntityId(this.geyserId);
        packet.setType(type);
        packet.setData(data);
        this.session.sendUpstreamPacket(packet);
    }

    public <I extends Entity> I as(Class<I> entityClass) {
        return (I)(entityClass.isInstance(this) ? this : null);
    }

    public GeyserSession getSession() {
        return this.session;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public long getGeyserId() {
        return this.geyserId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public Vector3f getMotion() {
        return this.motion;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getHeadYaw() {
        return this.headYaw;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public EntityDefinition<?> getDefinition() {
        return this.definition;
    }

    public boolean isValid() {
        return this.valid;
    }

    public float getBoundingBoxHeight() {
        return this.boundingBoxHeight;
    }

    public float getBoundingBoxWidth() {
        return this.boundingBoxWidth;
    }

    public String getNametag() {
        return this.nametag;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public List<Entity> getPassengers() {
        return this.passengers;
    }

    public Entity getVehicle() {
        return this.vehicle;
    }

    public GeyserDirtyMetadata getDirtyMetadata() {
        return this.dirtyMetadata;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public void setMotion(Vector3f motion) {
        this.motion = motion;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void setHeadYaw(float headYaw) {
        this.headYaw = headYaw;
    }

    public void setOnGround(boolean onGround) {
        this.onGround = onGround;
    }

    public void setDefinition(EntityDefinition<?> definition) {
        this.definition = definition;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setPassengers(List<Entity> passengers) {
        this.passengers = passengers;
    }

    public void setVehicle(Entity vehicle) {
        this.vehicle = vehicle;
    }

    protected void setFlagsDirty(boolean flagsDirty) {
        this.flagsDirty = flagsDirty;
    }
}

