/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.packet.AnimatePacket;
import com.nukkitx.protocol.bedrock.packet.MoveEntityAbsolutePacket;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;

public class BoatEntity
extends Entity {
    private static final String BUOYANCY_DATA = "{\"apply_gravity\":true,\"base_buoyancy\":1.0,\"big_wave_probability\":0.02999999932944775,\"big_wave_speed\":10.0,\"drag_down_on_buoyancy_removed\":0.0,\"liquid_blocks\":[\"minecraft:water\",\"minecraft:flowing_water\"],\"simulate_waves\":false}";
    private boolean isPaddlingLeft;
    private float paddleTimeLeft;
    private boolean isPaddlingRight;
    private float paddleTimeRight;
    private int variant;
    private final float ROWING_SPEED = 0.05f;

    public BoatEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position.add(0.0, (double)definition.offset(), 0.0), motion, yaw + 90.0f, 0.0f, yaw + 90.0f);
        this.dirtyMetadata.put(EntityData.IS_BUOYANT, (byte)1);
        this.dirtyMetadata.put(EntityData.BUOYANCY_DATA, BUOYANCY_DATA);
    }

    @Override
    public void moveAbsolute(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        this.setPosition(position.add(0.0, (double)this.definition.offset(), 0.0));
        this.setYaw(yaw + 90.0f);
        this.setHeadYaw(yaw + 90.0f);
        this.setOnGround(isOnGround);
        MoveEntityAbsolutePacket moveEntityPacket = new MoveEntityAbsolutePacket();
        moveEntityPacket.setRuntimeEntityId(this.geyserId);
        if (this.session.getPlayerEntity().getVehicle() == this && this.session.getPlayerEntity().isRidingInFront()) {
            moveEntityPacket.setPosition(position.up(EntityDefinitions.PLAYER.offset() - this.definition.offset()));
        } else {
            moveEntityPacket.setPosition(this.position);
        }
        moveEntityPacket.setRotation(this.getBedrockRotation());
        moveEntityPacket.setOnGround(isOnGround);
        moveEntityPacket.setTeleported(teleported);
        this.session.sendUpstreamPacket(moveEntityPacket);
    }

    public void moveAbsoluteWithoutAdjustments(Vector3f position, float yaw, boolean isOnGround, boolean teleported) {
        super.moveAbsolute(position, yaw, 0.0f, yaw, isOnGround, teleported);
    }

    @Override
    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        super.moveRelative(relX, relY, relZ, yaw, 0.0f, yaw, isOnGround);
    }

    @Override
    public void updatePositionAndRotation(double moveX, double moveY, double moveZ, float yaw, float pitch, boolean isOnGround) {
        this.moveRelative(moveX, moveY, moveZ, yaw + 90.0f, pitch, isOnGround);
    }

    @Override
    public void updateRotation(float yaw, float pitch, boolean isOnGround) {
        this.moveRelative(0.0, 0.0, 0.0, yaw + 90.0f, 0.0f, 0.0f, isOnGround);
    }

    public void setVariant(IntEntityMetadata entityMetadata) {
        this.variant = entityMetadata.getPrimitiveValue();
        this.dirtyMetadata.put(EntityData.VARIANT, this.variant);
    }

    public void setPaddlingLeft(BooleanEntityMetadata entityMetadata) {
        this.isPaddlingLeft = entityMetadata.getPrimitiveValue();
        if (this.isPaddlingLeft) {
            Entity entity;
            this.paddleTimeLeft = 0.0f;
            if (!this.passengers.isEmpty() && (entity = (Entity)this.passengers.get(0)) != null) {
                this.updateLeftPaddle(this.session, entity);
            }
        } else {
            this.dirtyMetadata.put(EntityData.ROW_TIME_LEFT, Float.valueOf(0.0f));
        }
    }

    public void setPaddlingRight(BooleanEntityMetadata entityMetadata) {
        this.isPaddlingRight = entityMetadata.getPrimitiveValue();
        if (this.isPaddlingRight) {
            Entity entity;
            this.paddleTimeRight = 0.0f;
            if (!this.passengers.isEmpty() && (entity = (Entity)this.passengers.get(0)) != null) {
                this.updateRightPaddle(this.session, entity);
            }
        } else {
            this.dirtyMetadata.put(EntityData.ROW_TIME_RIGHT, Float.valueOf(0.0f));
        }
    }

    @Override
    protected InteractiveTag testInteraction(Hand hand) {
        if (this.session.isSneaking()) {
            return InteractiveTag.NONE;
        }
        if (this.passengers.size() < 2) {
            return InteractiveTag.BOARD_BOAT;
        }
        return InteractiveTag.NONE;
    }

    @Override
    public InteractionResult interact(Hand hand) {
        if (this.session.isSneaking()) {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    private void updateLeftPaddle(GeyserSession session, Entity rower) {
        if (this.isPaddlingLeft) {
            this.paddleTimeLeft += 0.05f;
            this.sendAnimationPacket(session, rower, AnimatePacket.Action.ROW_LEFT, this.paddleTimeLeft);
            session.scheduleInEventLoop(() -> this.updateLeftPaddle(session, rower), 100L, TimeUnit.MILLISECONDS);
        }
    }

    private void updateRightPaddle(GeyserSession session, Entity rower) {
        if (this.isPaddlingRight) {
            this.paddleTimeRight += 0.05f;
            this.sendAnimationPacket(session, rower, AnimatePacket.Action.ROW_RIGHT, this.paddleTimeRight);
            session.scheduleInEventLoop(() -> this.updateRightPaddle(session, rower), 100L, TimeUnit.MILLISECONDS);
        }
    }

    private void sendAnimationPacket(GeyserSession session, Entity rower, AnimatePacket.Action action, float rowTime) {
        AnimatePacket packet = new AnimatePacket();
        packet.setRuntimeEntityId(rower.getGeyserId());
        packet.setAction(action);
        packet.setRowingTime(rowTime);
        session.sendUpstreamPacket(packet);
    }

    public int getVariant() {
        return this.variant;
    }
}

