/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.configuration;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.geysermc.geyser.configuration.EmoteOffhandWorkaroundOption;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.network.CIDRMatcher;
import org.geysermc.geyser.session.auth.AuthType;
import org.geysermc.geyser.text.AsteriskSerializer;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.relocate.jackson.annotation.JsonIgnore;
import org.geysermc.relocate.jackson.annotation.JsonIgnoreProperties;
import org.geysermc.relocate.jackson.annotation.JsonProperty;
import org.geysermc.relocate.jackson.core.JsonParser;
import org.geysermc.relocate.jackson.databind.DeserializationContext;
import org.geysermc.relocate.jackson.databind.JsonDeserializer;
import org.geysermc.relocate.jackson.databind.annotation.JsonDeserialize;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class GeyserJacksonConfiguration
implements GeyserConfiguration {
    private boolean autoconfiguredRemote = false;
    private BedrockConfiguration bedrock = new BedrockConfiguration();
    private RemoteConfiguration remote = new RemoteConfiguration();
    @JsonProperty(value="saved-user-logins")
    private List<String> savedUserLogins = Collections.emptyList();
    @JsonProperty(value="floodgate-key-file")
    private String floodgateKeyFile = "key.pem";
    private Map<String, UserAuthenticationInfo> userAuths;
    @JsonProperty(value="command-suggestions")
    private boolean commandSuggestions = true;
    @JsonProperty(value="passthrough-motd")
    private boolean isPassthroughMotd = false;
    @JsonProperty(value="passthrough-player-counts")
    private boolean isPassthroughPlayerCounts = false;
    @JsonProperty(value="passthrough-protocol-name")
    private boolean isPassthroughProtocolName = false;
    @JsonProperty(value="legacy-ping-passthrough")
    private boolean isLegacyPingPassthrough = false;
    @JsonProperty(value="ping-passthrough-interval")
    private int pingPassthroughInterval = 3;
    @JsonProperty(value="forward-player-ping")
    private boolean forwardPlayerPing = false;
    @JsonProperty(value="max-players")
    private int maxPlayers = 100;
    @JsonProperty(value="debug-mode")
    private boolean debugMode = false;
    @JsonProperty(value="allow-third-party-capes")
    private boolean allowThirdPartyCapes = true;
    @JsonProperty(value="show-cooldown")
    private String showCooldown = "title";
    @JsonProperty(value="show-coordinates")
    private boolean showCoordinates = true;
    @JsonProperty(value="disable-bedrock-scaffolding")
    private boolean disableBedrockScaffolding = false;
    @JsonProperty(value="always-quick-change-armor")
    private boolean alwaysQuickChangeArmor = false;
    @JsonDeserialize(using=EmoteOffhandWorkaroundOption.Deserializer.class)
    @JsonProperty(value="emote-offhand-workaround")
    private EmoteOffhandWorkaroundOption emoteOffhandWorkaround = EmoteOffhandWorkaroundOption.DISABLED;
    @JsonProperty(value="allow-third-party-ears")
    private boolean allowThirdPartyEars = false;
    @JsonProperty(value="default-locale")
    private String defaultLocale = null;
    @JsonProperty(value="cache-images")
    private int cacheImages = 0;
    @JsonProperty(value="allow-custom-skulls")
    private boolean allowCustomSkulls = true;
    @JsonProperty(value="max-visible-custom-skulls")
    private int maxVisibleCustomSkulls = 128;
    @JsonProperty(value="custom-skull-render-distance")
    private int customSkullRenderDistance = 32;
    @JsonProperty(value="add-non-bedrock-items")
    private boolean addNonBedrockItems = true;
    @JsonProperty(value="above-bedrock-nether-building")
    private boolean aboveBedrockNetherBuilding = false;
    @JsonProperty(value="force-resource-packs")
    private boolean forceResourcePacks = true;
    @JsonProperty(value="xbox-achievements-enabled")
    private boolean xboxAchievementsEnabled = false;
    private MetricsInfo metrics = new MetricsInfo();
    @JsonProperty(value="pending-authentication-timeout")
    private int pendingAuthenticationTimeout = 120;
    @JsonProperty(value="scoreboard-packet-threshold")
    private int scoreboardPacketThreshold = 10;
    @JsonProperty(value="enable-proxy-connections")
    private boolean enableProxyConnections = false;
    @JsonProperty(value="mtu")
    private int mtu = 1400;
    @JsonProperty(value="use-direct-connection")
    private boolean useDirectConnection = true;
    @JsonProperty(value="config-version")
    private int configVersion = 0;

    @Override
    public abstract Path getFloodgateKeyPath();

    public boolean isAutoconfiguredRemote() {
        return this.autoconfiguredRemote;
    }

    @Override
    public BedrockConfiguration getBedrock() {
        return this.bedrock;
    }

    @Override
    public RemoteConfiguration getRemote() {
        return this.remote;
    }

    @Override
    public List<String> getSavedUserLogins() {
        return this.savedUserLogins;
    }

    public String getFloodgateKeyFile() {
        return this.floodgateKeyFile;
    }

    public Map<String, UserAuthenticationInfo> getUserAuths() {
        return this.userAuths;
    }

    @Override
    public boolean isCommandSuggestions() {
        return this.commandSuggestions;
    }

    @Override
    public boolean isPassthroughMotd() {
        return this.isPassthroughMotd;
    }

    @Override
    public boolean isPassthroughPlayerCounts() {
        return this.isPassthroughPlayerCounts;
    }

    @Override
    public boolean isPassthroughProtocolName() {
        return this.isPassthroughProtocolName;
    }

    @Override
    public boolean isLegacyPingPassthrough() {
        return this.isLegacyPingPassthrough;
    }

    @Override
    public int getPingPassthroughInterval() {
        return this.pingPassthroughInterval;
    }

    @Override
    public boolean isForwardPlayerPing() {
        return this.forwardPlayerPing;
    }

    @Override
    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    @Override
    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    public boolean isAllowThirdPartyCapes() {
        return this.allowThirdPartyCapes;
    }

    @Override
    public String getShowCooldown() {
        return this.showCooldown;
    }

    @Override
    public boolean isShowCoordinates() {
        return this.showCoordinates;
    }

    @Override
    public boolean isDisableBedrockScaffolding() {
        return this.disableBedrockScaffolding;
    }

    @Override
    public boolean isAlwaysQuickChangeArmor() {
        return this.alwaysQuickChangeArmor;
    }

    @Override
    public EmoteOffhandWorkaroundOption getEmoteOffhandWorkaround() {
        return this.emoteOffhandWorkaround;
    }

    @Override
    public boolean isAllowThirdPartyEars() {
        return this.allowThirdPartyEars;
    }

    @Override
    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public int getCacheImages() {
        return this.cacheImages;
    }

    @Override
    public boolean isAllowCustomSkulls() {
        return this.allowCustomSkulls;
    }

    @Override
    public int getMaxVisibleCustomSkulls() {
        return this.maxVisibleCustomSkulls;
    }

    @Override
    public int getCustomSkullRenderDistance() {
        return this.customSkullRenderDistance;
    }

    @Override
    public boolean isAddNonBedrockItems() {
        return this.addNonBedrockItems;
    }

    @Override
    public boolean isAboveBedrockNetherBuilding() {
        return this.aboveBedrockNetherBuilding;
    }

    @Override
    public boolean isForceResourcePacks() {
        return this.forceResourcePacks;
    }

    @Override
    public boolean isXboxAchievementsEnabled() {
        return this.xboxAchievementsEnabled;
    }

    @Override
    public MetricsInfo getMetrics() {
        return this.metrics;
    }

    @Override
    public int getPendingAuthenticationTimeout() {
        return this.pendingAuthenticationTimeout;
    }

    @Override
    public int getScoreboardPacketThreshold() {
        return this.scoreboardPacketThreshold;
    }

    @Override
    public boolean isEnableProxyConnections() {
        return this.enableProxyConnections;
    }

    @Override
    public int getMtu() {
        return this.mtu;
    }

    @Override
    public boolean isUseDirectConnection() {
        return this.useDirectConnection;
    }

    @Override
    public int getConfigVersion() {
        return this.configVersion;
    }

    public void setAutoconfiguredRemote(boolean autoconfiguredRemote) {
        this.autoconfiguredRemote = autoconfiguredRemote;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class BedrockConfiguration
    implements GeyserConfiguration.IBedrockConfiguration {
        @AsteriskSerializer.Asterisk(isIp=true)
        private String address = "0.0.0.0";
        private int port = 19132;
        @JsonProperty(value="clone-remote-port")
        private boolean cloneRemotePort = false;
        private String motd1 = "GeyserMC";
        private String motd2 = "Geyser";
        @JsonProperty(value="server-name")
        private String serverName = "Geyser";
        @JsonProperty(value="compression-level")
        private int compressionLevel = 6;
        @JsonProperty(value="enable-proxy-protocol")
        private boolean enableProxyProtocol = false;
        @JsonProperty(value="proxy-protocol-whitelisted-ips")
        private List<String> proxyProtocolWhitelistedIPs = Collections.emptyList();
        @JsonIgnore
        private List<CIDRMatcher> whitelistedIPsMatchers = null;

        @Override
        public int getCompressionLevel() {
            return Math.max(-1, Math.min(this.compressionLevel, 9));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<CIDRMatcher> getWhitelistedIPsMatchers() {
            List<CIDRMatcher> matchers = this.whitelistedIPsMatchers;
            if (matchers == null) {
                BedrockConfiguration bedrockConfiguration = this;
                synchronized (bedrockConfiguration) {
                    this.whitelistedIPsMatchers = matchers = this.proxyProtocolWhitelistedIPs.stream().map(CIDRMatcher::new).collect(Collectors.toList());
                }
            }
            return Collections.unmodifiableList(matchers);
        }

        @Override
        public String getAddress() {
            return this.address;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public boolean isCloneRemotePort() {
            return this.cloneRemotePort;
        }

        @Override
        public String getMotd1() {
            return this.motd1;
        }

        @Override
        public String getMotd2() {
            return this.motd2;
        }

        @Override
        public String getServerName() {
            return this.serverName;
        }

        @Override
        public boolean isEnableProxyProtocol() {
            return this.enableProxyProtocol;
        }

        @Override
        public List<String> getProxyProtocolWhitelistedIPs() {
            return this.proxyProtocolWhitelistedIPs;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RemoteConfiguration
    implements GeyserConfiguration.IRemoteConfiguration {
        @AsteriskSerializer.Asterisk(isIp=true)
        private String address = "auto";
        @JsonDeserialize(using=PortDeserializer.class)
        private int port = 25565;
        @JsonDeserialize(using=AuthType.Deserializer.class)
        @JsonProperty(value="auth-type")
        private AuthType authType = AuthType.ONLINE;
        @JsonProperty(value="allow-password-authentication")
        private boolean passwordAuthentication = true;
        @JsonProperty(value="use-proxy-protocol")
        private boolean useProxyProtocol = false;
        @JsonProperty(value="forward-hostname")
        private boolean forwardHost = false;

        @Override
        public String getAddress() {
            return this.address;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public AuthType getAuthType() {
            return this.authType;
        }

        @Override
        public boolean isPasswordAuthentication() {
            return this.passwordAuthentication;
        }

        @Override
        public boolean isUseProxyProtocol() {
            return this.useProxyProtocol;
        }

        @Override
        public boolean isForwardHost() {
            return this.forwardHost;
        }

        @Override
        public void setAddress(String address) {
            this.address = address;
        }

        @Override
        @JsonDeserialize(using=PortDeserializer.class)
        public void setPort(int port) {
            this.port = port;
        }

        @JsonDeserialize(using=AuthType.Deserializer.class)
        @JsonProperty(value="auth-type")
        public void setAuthType(AuthType authType) {
            this.authType = authType;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MetricsInfo
    implements GeyserConfiguration.IMetricsInfo {
        private boolean enabled = true;
        @JsonDeserialize(using=MetricsIdDeserializer.class)
        @JsonProperty(value="uuid")
        private String uniqueId = UUID.randomUUID().toString();

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public String getUniqueId() {
            return this.uniqueId;
        }

        private static class MetricsIdDeserializer
        extends JsonDeserializer<String> {
            private MetricsIdDeserializer() {
            }

            @Override
            public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String uuid = p.getValueAsString();
                if ("generateduuid".equals(uuid)) {
                    return UUID.randomUUID().toString();
                }
                return uuid;
            }
        }
    }

    protected static class PortDeserializer
    extends JsonDeserializer<Integer> {
        protected PortDeserializer() {
        }

        @Override
        public Integer deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String value = p.getValueAsString();
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                System.err.println(GeyserLocale.getLocaleStringLog("geyser.bootstrap.config.invalid_port", new Object[0]));
                return 25565;
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UserAuthenticationInfo
    implements GeyserConfiguration.IUserAuthenticationInfo {
        @AsteriskSerializer.Asterisk
        private String email;
        @AsteriskSerializer.Asterisk
        private String password;
        @JsonProperty(value="microsoft-account")
        private boolean microsoftAccount = false;

        @Override
        public String getEmail() {
            return this.email;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        @Override
        public boolean isMicrosoftAccount() {
            return this.microsoftAccount;
        }
    }
}

