/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command.defaults;

import com.nukkitx.protocol.bedrock.BedrockPacketCodec;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import org.geysermc.common.PlatformType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.command.CommandSender;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.network.MinecraftProtocol;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.WebUtils;

public class VersionCommand
extends GeyserCommand {
    private final GeyserImpl geyser;

    public VersionCommand(GeyserImpl geyser, String name, String description, String permission) {
        super(name, description, permission);
        this.geyser = geyser;
    }

    @Override
    public void execute(GeyserSession session, CommandSender sender, String[] args) {
        block12: {
            List<BedrockPacketCodec> supportedCodecs = MinecraftProtocol.SUPPORTED_BEDROCK_CODECS;
            Object bedrockVersions = supportedCodecs.size() > 1 ? supportedCodecs.get(0).getMinecraftVersion() + " - " + supportedCodecs.get(supportedCodecs.size() - 1).getMinecraftVersion() : MinecraftProtocol.SUPPORTED_BEDROCK_CODECS.get(0).getMinecraftVersion();
            List<String> supportedJavaVersions = MinecraftProtocol.getJavaVersions();
            Object javaVersions = supportedJavaVersions.size() > 1 ? supportedJavaVersions.get(0) + " - " + supportedJavaVersions.get(supportedJavaVersions.size() - 1) : supportedJavaVersions.get(0);
            sender.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.version.version", sender.getLocale(), "Geyser", "2.0.6-SNAPSHOT (git-eab92da98884308b6e4b4a5deb1de97b2fbd3c6e-eab92da)", javaVersions, bedrockVersions));
            if (GeyserImpl.getInstance().productionEnvironment() && (sender.isConsole() || this.geyser.getPlatformType() != PlatformType.STANDALONE)) {
                sender.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.version.checking", sender.getLocale(), new Object[0]));
                try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResource("git.properties");){
                    Properties gitProp = new Properties();
                    gitProp.load(stream);
                    String buildXML = WebUtils.getBody("https://ci.opencollab.dev/job/GeyserMC/job/Geyser/job/" + URLEncoder.encode(gitProp.getProperty("git.branch"), StandardCharsets.UTF_8.toString()) + "/lastSuccessfulBuild/api/xml?xpath=//buildNumber");
                    if (buildXML.startsWith("<buildNumber>")) {
                        int buildNum;
                        int latestBuildNum = Integer.parseInt(buildXML.replaceAll("<(\\\\)?(/)?buildNumber>", "").trim());
                        if (latestBuildNum == (buildNum = Integer.parseInt(gitProp.getProperty("git.build.number")))) {
                            sender.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.version.no_updates", sender.getLocale(), new Object[0]));
                        } else {
                            sender.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.version.outdated", sender.getLocale(), latestBuildNum - buildNum, "https://ci.geysermc.org/"));
                        }
                        break block12;
                    }
                    throw new AssertionError((Object)"buildNumber missing");
                }
                catch (IOException | AssertionError | NumberFormatException e) {
                    GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.commands.version.failed", new Object[0]), (Throwable)e);
                    sender.sendMessage("\u00a7c" + GeyserLocale.getPlayerLocaleString("geyser.commands.version.failed", sender.getLocale(), new Object[0]));
                }
            }
        }
    }

    @Override
    public boolean isSuggestedOpOnly() {
        return true;
    }
}

