/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command.defaults;

import org.geysermc.common.PlatformType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.command.CommandSender;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;

public class ReloadCommand
extends GeyserCommand {
    private final GeyserImpl geyser;

    public ReloadCommand(GeyserImpl geyser, String name, String description, String permission) {
        super(name, description, permission);
        this.geyser = geyser;
    }

    @Override
    public void execute(GeyserSession session, CommandSender sender, String[] args) {
        if (!sender.isConsole() && this.geyser.getPlatformType() == PlatformType.STANDALONE) {
            return;
        }
        String message = GeyserLocale.getPlayerLocaleString("geyser.commands.reload.message", sender.getLocale(), new Object[0]);
        sender.sendMessage(message);
        this.geyser.getSessionManager().disconnectAll("geyser.commands.reload.kick");
        this.geyser.reload();
    }

    @Override
    public boolean isSuggestedOpOnly() {
        return true;
    }
}

