/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command.defaults;

import java.util.Collections;
import java.util.Map;
import org.geysermc.common.PlatformType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.command.CommandSender;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;

public class HelpCommand
extends GeyserCommand {
    private final GeyserImpl geyser;

    public HelpCommand(GeyserImpl geyser, String name, String description, String permission) {
        super(name, description, permission);
        this.geyser = geyser;
        this.setAliases(Collections.singletonList("?"));
    }

    @Override
    public void execute(GeyserSession session, CommandSender sender, String[] args) {
        int page = 1;
        int maxPage = 1;
        String header = GeyserLocale.getPlayerLocaleString("geyser.commands.help.header", sender.getLocale(), page, maxPage);
        sender.sendMessage(header);
        Map<String, GeyserCommand> cmds = this.geyser.getCommandManager().getCommands();
        for (Map.Entry<String, GeyserCommand> entry : cmds.entrySet()) {
            GeyserCommand cmd = entry.getValue();
            if (this.geyser.getPlatformType() != PlatformType.STANDALONE && !sender.hasPermission(cmd.getPermission()) || cmd.isBedrockOnly() && session == null) continue;
            sender.sendMessage("\u00a7e/geyser " + entry.getKey() + "\u00a7f: " + GeyserLocale.getPlayerLocaleString(cmd.getDescription(), sender.getLocale(), new Object[0]));
        }
    }
}

