/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command.defaults;

import java.util.concurrent.CompletableFuture;
import org.geysermc.common.PlatformType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.command.CommandSender;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.LoopbackUtil;
import org.geysermc.geyser.util.WebUtils;
import org.geysermc.relocate.jackson.databind.JsonNode;
import org.jetbrains.annotations.Nullable;

public class ConnectionTestCommand
extends GeyserCommand {
    private final GeyserImpl geyser;

    public ConnectionTestCommand(GeyserImpl geyser, String name, String description, String permission) {
        super(name, description, permission);
        this.geyser = geyser;
    }

    @Override
    public void execute(@Nullable GeyserSession session, CommandSender sender, String[] args) {
        if (!sender.isConsole() && this.geyser.getPlatformType() == PlatformType.STANDALONE) {
            sender.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.bootstrap.command.permission_fail", sender.getLocale(), new Object[0]));
            return;
        }
        if (args.length == 0) {
            sender.sendMessage("Provide the Bedrock server IP you are trying to connect with. Example: `test.geysermc.org:19132`");
            return;
        }
        String[] fullAddress = args[0].split(":", 2);
        int port = fullAddress.length == 2 ? Integer.parseInt(fullAddress[1]) : 19132;
        if (port != this.geyser.getConfig().getBedrock().getPort()) {
            sender.sendMessage("The port you supplied (" + port + ") does not match the port supplied in Geyser's configuration (" + this.geyser.getConfig().getBedrock().getPort() + "). You can change it under `bedrock` `port`.");
        }
        if (!this.geyser.getConfig().getBedrock().getAddress().equals("0.0.0.0")) {
            sender.sendMessage("The address specified in `bedrock` `address` is not \"0.0.0.0\" - this may cause issues unless this is deliberate and intentional.");
        }
        if (this.geyser.getConfig().getBedrock().isEnableProxyProtocol()) {
            sender.sendMessage("You have the `enable-proxy-protocol` setting enabled. Unless you're deliberately using additional software that REQUIRES this setting, you may not need it enabled.");
        }
        CompletableFuture.runAsync(() -> {
            try {
                JsonNode output;
                long cacheTime;
                String ip = fullAddress[0];
                String[] record = WebUtils.findSrvRecord(this.geyser, ip);
                if (record != null && !ip.equals(record[3]) && !record[2].equals(String.valueOf(port))) {
                    sender.sendMessage("Bedrock Edition does not support SRV records. Try connecting to your server using the address " + record[3] + " and the port " + record[2] + ". If that fails, re-run this command with that address and port.");
                    return;
                }
                if (LoopbackUtil.needsLoopback(GeyserImpl.getInstance().getLogger())) {
                    sender.sendMessage("Loopback is not applied on this computer! You will have issues connecting from the same computer. See here for steps on how to resolve: https://wiki.geysermc.org/geyser/fixing-unable-to-connect-to-world/#using-geyser-on-the-same-computer");
                }
                Object when = (cacheTime = (output = WebUtils.getJson("https://api.mcsrvstat.us/bedrock/2/" + args[0])).get("debug").get("cachetime").asLong()) == 0L ? "now" : System.currentTimeMillis() / 1000L - cacheTime + " seconds ago";
                if (output.get("online").asBoolean()) {
                    sender.sendMessage("Your server is likely online as of " + (String)when + "!");
                    this.sendLinks(sender);
                    return;
                }
                sender.sendMessage("Your server is likely unreachable from outside the network as of " + (String)when + ".");
                this.sendLinks(sender);
            }
            catch (Exception e) {
                sender.sendMessage("Error while trying to check your connection!");
                this.geyser.getLogger().error("Error while trying to check your connection!", e);
            }
        });
    }

    private void sendLinks(CommandSender sender) {
        sender.sendMessage("If you still have issues, check to see if your hosting provider has a specific setup: https://wiki.geysermc.org/geyser/supported-hosting-providers/, see this page: https://wiki.geysermc.org/geyser/fixing-unable-to-connect-to-world/, or contact us on our Discord: https://discord.gg/geysermc");
    }

    @Override
    public boolean isSuggestedOpOnly() {
        return true;
    }
}

