/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.command.CommandSender;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.session.GeyserSession;

public class CommandExecutor {
    protected final GeyserImpl geyser;

    public GeyserCommand getCommand(String label) {
        return this.geyser.getCommandManager().getCommands().get(label);
    }

    @Nullable
    public GeyserSession getGeyserSession(CommandSender sender) {
        if (sender.isConsole()) {
            return null;
        }
        for (GeyserSession session : this.geyser.getSessionManager().getSessions().values()) {
            if (!sender.name().equals(session.getPlayerEntity().getUsername())) continue;
            return session;
        }
        return null;
    }

    public List<String> tabComplete(CommandSender sender) {
        if (this.getGeyserSession(sender) != null) {
            return Collections.emptyList();
        }
        ArrayList<String> availableCommands = new ArrayList<String>();
        Map<String, GeyserCommand> commands = this.geyser.getCommandManager().getCommands();
        for (Map.Entry<String, GeyserCommand> entry : commands.entrySet()) {
            GeyserCommand geyserCommand = entry.getValue();
            if (!sender.hasPermission(geyserCommand.getPermission()) || geyserCommand.isBedrockOnly()) continue;
            availableCommands.add(entry.getKey());
        }
        return availableCommands;
    }

    public CommandExecutor(GeyserImpl geyser) {
        this.geyser = geyser;
    }
}

