/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Scanner;
import javax.swing.JOptionPane;

public class GeyserMain {
    public void displayMessage() {
        String message = this.createMessage();
        if (System.console() == null && !this.isHeadless()) {
            JOptionPane.showMessageDialog(null, message, "GeyserMC Plugin: " + this.getPluginType(), 0);
        }
        this.printMessage(message);
    }

    private String createMessage() {
        StringBuilder message = new StringBuilder();
        InputStream helpStream = GeyserMain.class.getClassLoader().getResourceAsStream("languages/run-help/" + Locale.getDefault().toString() + ".txt");
        if (helpStream == null) {
            helpStream = GeyserMain.class.getClassLoader().getResourceAsStream("languages/run-help/en_US.txt");
        }
        Scanner help = new Scanner(helpStream).useDelimiter("\\Z");
        String line = "";
        while (help.hasNext()) {
            line = help.next();
            line = line.replace("${plugin_type}", this.getPluginType());
            line = line.replace("${plugin_folder}", this.getPluginFolder());
            message.append(line).append("\n");
        }
        return message.toString();
    }

    private boolean isHeadless() {
        try {
            Class<?> graphicsEnvironment = Class.forName("java.awt.GraphicsEnvironment");
            Method isHeadless = graphicsEnvironment.getDeclaredMethod("isHeadless", new Class[0]);
            return (Boolean)isHeadless.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return true;
        }
    }

    private void printMessage(String message) {
        System.out.print(message);
    }

    public String getPluginType() {
        return "unknown";
    }

    public String getPluginFolder() {
        return "unknown";
    }
}

