/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser;

import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.command.CommandManager;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.level.GeyserWorldManager;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;

public interface GeyserBootstrap {
    public static final GeyserWorldManager DEFAULT_CHUNK_MANAGER = new GeyserWorldManager();

    public void onEnable();

    public void onDisable();

    public GeyserConfiguration getGeyserConfig();

    public GeyserLogger getGeyserLogger();

    public CommandManager getGeyserCommandManager();

    public IGeyserPingPassthrough getGeyserPingPassthrough();

    default public WorldManager getWorldManager() {
        return DEFAULT_CHUNK_MANAGER;
    }

    public Path getConfigFolder();

    default public Path getSavedUserLoginsFolder() {
        return this.getConfigFolder();
    }

    public BootstrapDumpInfo getDumpInfo();

    @Nullable
    default public String getMinecraftServerVersion() {
        return null;
    }

    @Nullable
    default public SocketAddress getSocketAddress() {
        return null;
    }

    default public Path getLogsPath() {
        return Paths.get("logs/latest.log", new String[0]);
    }

    @Nullable
    default public InputStream getResourceOrNull(String resource) {
        return GeyserBootstrap.class.getClassLoader().getResourceAsStream(resource);
    }

    @Nonnull
    default public InputStream getResource(String resource) {
        InputStream stream = this.getResourceOrNull(resource);
        if (stream == null) {
            throw new AssertionError((Object)("Unable to find resource: " + resource));
        }
        return stream;
    }
}

