/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.configuration.GeyserJacksonConfiguration;
import org.geysermc.geyser.session.auth.AuthType;
import org.geysermc.geyser.text.GeyserLocale;

public class FloodgateKeyLoader {
    public static Path getKeyPath(GeyserJacksonConfiguration config, Path floodgateDataFolder, Path geyserDataFolder, GeyserLogger logger) {
        Path floodgateKey;
        if (config.getRemote().getAuthType() != AuthType.FLOODGATE) {
            return geyserDataFolder.resolve(config.getFloodgateKeyFile());
        }
        if (floodgateDataFolder != null) {
            Path autoKey = floodgateDataFolder.resolve("key.pem");
            if (Files.exists(autoKey, new LinkOption[0])) {
                logger.debug(GeyserLocale.getLocaleStringLog("geyser.bootstrap.floodgate.auto_loaded", new Object[0]));
                return autoKey;
            }
            logger.error(GeyserLocale.getLocaleStringLog("geyser.bootstrap.floodgate.missing_key", new Object[0]));
        }
        if (config.getFloodgateKeyFile().equals("public-key.pem")) {
            logger.debug("Floodgate 2.0 doesn't use a public/private key system anymore. We'll search for key.pem instead");
            floodgateKey = geyserDataFolder.resolve("key.pem");
        } else {
            floodgateKey = geyserDataFolder.resolve(config.getFloodgateKeyFile());
        }
        if (!Files.exists(floodgateKey, new LinkOption[0])) {
            logger.error(GeyserLocale.getLocaleStringLog("geyser.bootstrap.floodgate.not_installed", new Object[0]));
        }
        return floodgateKey;
    }
}

