/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.form.impl.simple;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.cumulus.component.ButtonComponent;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.form.impl.simple.SimpleFormImpl;
import org.geysermc.cumulus.form.util.FormType;
import org.geysermc.cumulus.form.util.impl.FormCodecImpl;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.response.impl.SimpleFormResponseImpl;
import org.geysermc.cumulus.response.result.FormResponseResult;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.cumulus.util.JsonUtils;
import org.geysermc.cumulus.util.impl.FormImageAdaptor;

public final class SimpleFormCodec
extends FormCodecImpl<SimpleForm, SimpleFormResponse> {
    SimpleFormCodec() {
        super(SimpleForm.class, FormType.SIMPLE_FORM);
    }

    @Override
    protected SimpleForm deserializeForm(JsonObject source, JsonDeserializationContext context) {
        String title = JsonUtils.assumeMember(source, "title").getAsString();
        String content = JsonUtils.assumeMember(source, "content").getAsString();
        JsonElement buttonsElement = JsonUtils.assumeMember(source, "buttons");
        List buttons = (List)context.deserialize(buttonsElement, LIST_BUTTON_TYPE);
        return new SimpleFormImpl(title, content, buttons);
    }

    @Override
    protected void serializeForm(SimpleForm form, JsonSerializationContext context, JsonObject result) {
        result.addProperty("title", form.title());
        result.addProperty("content", form.content());
        JsonArray buttons = new JsonArray();
        for (ButtonComponent button : form.buttons()) {
            if (button == null) continue;
            buttons.add(context.serialize((Object)button));
        }
        result.add("buttons", (JsonElement)buttons);
    }

    @Override
    protected FormResponseResult<SimpleFormResponse> deserializeResponse(@NonNull SimpleForm form, @NonNull String data) {
        int buttonId;
        data = data.trim();
        try {
            buttonId = Integer.parseInt(data);
        }
        catch (Exception exception) {
            return FormResponseResult.invalid(-1, "Received invalid integer representing the clicked button");
        }
        if (buttonId < 0) {
            return FormResponseResult.invalid(-1, "Received a clicked button id that's smaller than 0");
        }
        ButtonComponent button = null;
        int correctButtonId = -1;
        for (int i = 0; i < form.buttons().size(); ++i) {
            ButtonComponent current = form.buttons().get(i);
            if (current == null || buttonId-- != 0) continue;
            button = form.buttons().get(i);
            correctButtonId = i;
        }
        if (button == null) {
            return FormResponseResult.invalid(-1, "Receiver a button id larger than the amount of buttons in the form");
        }
        return FormResponseResult.valid(SimpleFormResponseImpl.of(correctButtonId, button));
    }

    @Override
    protected void initializeGson(GsonBuilder builder) {
        super.initializeGson(builder);
        builder.registerTypeAdapter(FormImage.class, (Object)new FormImageAdaptor());
    }
}

