/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.component.impl;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.cumulus.component.StepSliderComponent;
import org.geysermc.cumulus.component.impl.ComponentImpl;
import org.geysermc.cumulus.component.util.ComponentType;

public final class StepSliderComponentImpl
extends ComponentImpl
implements StepSliderComponent {
    private final List<String> steps;
    @SerializedName(value="default")
    private final int defaultStep;

    public StepSliderComponentImpl(@NonNull String text, @NonNull List<String> steps, int defaultStep) {
        super(ComponentType.STEP_SLIDER, text);
        Preconditions.checkNotNull(steps, (Object)"steps");
        Preconditions.checkArgument((defaultStep >= 0 ? 1 : 0) != 0, (Object)"defaultStep");
        this.steps = Collections.unmodifiableList(steps);
        if (defaultStep >= steps.size()) {
            defaultStep = 0;
        }
        this.defaultStep = defaultStep;
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static @NonNull Builder builder(@NonNull String text) {
        return StepSliderComponentImpl.builder().text(text);
    }

    @Override
    public @NonNull List<String> steps() {
        return this.steps;
    }

    @Override
    public @NonNegative int defaultStep() {
        return this.defaultStep;
    }

    @Override
    public List<String> getSteps() {
        return this.steps();
    }

    @Override
    public int getDefaultStep() {
        return this.defaultStep();
    }

    public static final class Builder
    implements StepSliderComponent.Builder {
        private final List<String> steps = new ArrayList<String>();
        private String text = "";
        private int defaultStep;

        @Override
        public Builder text(@NonNull String text) {
            this.text = Objects.requireNonNull(text, "text");
            return this;
        }

        @Override
        public Builder step(@NonNull String step, boolean isDefault) {
            this.steps.add(Objects.requireNonNull(step, "step"));
            if (isDefault) {
                this.defaultStep = this.steps.size() - 1;
            }
            return this;
        }

        @Override
        public Builder step(@NonNull String step) {
            return this.step(step, false);
        }

        @Override
        public Builder defaultStep(int defaultStep) {
            Preconditions.checkArgument((defaultStep >= 0 ? 1 : 0) != 0, (Object)"defaultStep");
            Preconditions.checkArgument((this.steps.size() > defaultStep ? 1 : 0) != 0, (Object)"defaultStep is out of bounds");
            this.defaultStep = defaultStep;
            return this;
        }

        @Override
        public @NonNull StepSliderComponentImpl build() {
            return new StepSliderComponentImpl(this.text, this.steps, this.defaultStep);
        }

        @Override
        public @NonNull StepSliderComponentImpl translateAndBuild(@NonNull Function<String, String> translator) {
            Objects.requireNonNull(translator, "translator");
            this.steps.replaceAll(translator::apply);
            return new StepSliderComponentImpl(translator.apply(this.text), this.steps, this.defaultStep);
        }
    }
}

