/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.api;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.api.GeyserApiBase;

@NonNull
public class Geyser {
    private static GeyserApiBase api;

    public static GeyserApiBase api() {
        if (api == null) {
            throw new RuntimeException("Api has not been registered yet!");
        }
        return api;
    }

    public static <T extends GeyserApiBase> T api(@NonNull Class<T> apiClass) {
        if (apiClass.isInstance(api)) {
            return (T)api;
        }
        if (api == null) {
            throw new RuntimeException("Api has not been registered yet!");
        }
        throw new RuntimeException("Api was not an instance of " + apiClass + "! Was " + api.getClass().getCanonicalName());
    }

    public static void set(@NonNull GeyserApiBase api) {
        if (Geyser.api != null) {
            throw new RuntimeException("Cannot redefine already registered api!");
        }
        Geyser.api = api;
    }

    public static boolean registered() {
        return api != null;
    }
}

