/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.wrapper;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockPacketCodec;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.exception.PacketSerializeException;
import com.nukkitx.protocol.bedrock.wrapper.BedrockWrapperSerializer;
import com.nukkitx.protocol.util.Zlib;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import java.util.Collection;
import java.util.zip.DataFormatException;

public class BedrockWrapperSerializerV8
extends BedrockWrapperSerializer {
    public static final BedrockWrapperSerializerV8 INSTANCE = new BedrockWrapperSerializerV8();
    private static final Zlib ZLIB = Zlib.DEFAULT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(ByteBuf buffer, BedrockPacketCodec codec, Collection<BedrockPacket> packets, int level, BedrockSession session) {
        ByteBuf uncompressed = ByteBufAllocator.DEFAULT.ioBuffer(packets.size() << 3);
        try {
            for (BedrockPacket packet : packets) {
                ByteBuf packetBuffer = ByteBufAllocator.DEFAULT.ioBuffer();
                try {
                    int id = codec.getId(packet);
                    packetBuffer.writeByte(id);
                    packetBuffer.writeByte(packet.getSenderId());
                    packetBuffer.writeByte(packet.getClientId());
                    codec.tryEncode(packetBuffer, packet, session);
                    VarInts.writeUnsignedInt(uncompressed, packetBuffer.readableBytes());
                    uncompressed.writeBytes(packetBuffer);
                }
                catch (PacketSerializeException e) {
                    log.error("Error occurred whilst encoding " + packet.getClass().getSimpleName(), e);
                }
                finally {
                    packetBuffer.release();
                }
            }
            ZLIB.deflate(uncompressed, buffer, level);
        }
        catch (DataFormatException e) {
            throw new RuntimeException("Unable to deflate buffer data", e);
        }
        finally {
            uncompressed.release();
        }
    }

    @Override
    public void deserialize(ByteBuf compressed, BedrockPacketCodec codec, Collection<BedrockPacket> packets, BedrockSession session) {
        ByteBuf decompressed = ByteBufAllocator.DEFAULT.ioBuffer();
        try {
            ZLIB.inflate(compressed, decompressed, 0x200000);
            while (decompressed.isReadable()) {
                int length = VarInts.readUnsignedInt(decompressed);
                ByteBuf packetBuffer = decompressed.readSlice(length);
                if (!packetBuffer.isReadable()) {
                    throw new DataFormatException("Packet cannot be empty");
                }
                try {
                    short packetId = packetBuffer.readUnsignedByte();
                    BedrockPacket packet = codec.tryDecode(packetBuffer, packetId, session);
                    packet.setPacketId(packetId);
                    packet.setSenderId(packetBuffer.readUnsignedByte());
                    packet.setClientId(packetBuffer.readUnsignedByte());
                    packets.add(packet);
                }
                catch (PacketSerializeException e) {
                    log.debug("Error occurred whilst decoding packet", e);
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Packet contents\n{}", (Object)ByteBufUtil.prettyHexDump(packetBuffer.readerIndex(0)));
                }
            }
        }
        catch (DataFormatException e) {
            throw new RuntimeException("Unable to inflate buffer data", e);
        }
        finally {
            decompressed.release();
        }
    }

    private BedrockWrapperSerializerV8() {
    }
}

