/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v471;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.data.LevelEventType;
import com.nukkitx.protocol.bedrock.data.SoundEvent;
import com.nukkitx.protocol.bedrock.data.inventory.stackrequestactions.CraftGrindstoneStackRequestActionData;
import com.nukkitx.protocol.bedrock.data.inventory.stackrequestactions.CraftLoomStackRequestActionData;
import com.nukkitx.protocol.bedrock.data.inventory.stackrequestactions.StackRequestActionData;
import com.nukkitx.protocol.bedrock.data.inventory.stackrequestactions.StackRequestActionType;
import com.nukkitx.protocol.bedrock.v465.BedrockPacketHelper_v465;
import io.netty.buffer.ByteBuf;

public class BedrockPacketHelper_v471
extends BedrockPacketHelper_v465 {
    public static final BedrockPacketHelper_v471 INSTANCE = new BedrockPacketHelper_v471();

    @Override
    protected void registerEntityEvents() {
        super.registerEntityEvents();
    }

    @Override
    protected void registerLevelEvents() {
        super.registerLevelEvents();
        this.addLevelEvent(2036, LevelEventType.SCULK_CATALYST_BLOOM);
        int legacy2 = 16384;
        this.addLevelEvent(83 + legacy2, LevelEventType.PARTICLE_SCULK_SOUL);
    }

    @Override
    protected void registerSoundEvents() {
        super.registerSoundEvents();
        this.addSoundEvent(365, SoundEvent.SCULK_CATALYST_BLOOM);
    }

    @Override
    protected void registerStackActionRequestTypes() {
        this.stackRequestActionTypes.put(0, StackRequestActionType.TAKE);
        this.stackRequestActionTypes.put(1, StackRequestActionType.PLACE);
        this.stackRequestActionTypes.put(2, StackRequestActionType.SWAP);
        this.stackRequestActionTypes.put(3, StackRequestActionType.DROP);
        this.stackRequestActionTypes.put(4, StackRequestActionType.DESTROY);
        this.stackRequestActionTypes.put(5, StackRequestActionType.CONSUME);
        this.stackRequestActionTypes.put(6, StackRequestActionType.CREATE);
        this.stackRequestActionTypes.put(7, StackRequestActionType.LAB_TABLE_COMBINE);
        this.stackRequestActionTypes.put(8, StackRequestActionType.BEACON_PAYMENT);
        this.stackRequestActionTypes.put(9, StackRequestActionType.MINE_BLOCK);
        this.stackRequestActionTypes.put(10, StackRequestActionType.CRAFT_RECIPE);
        this.stackRequestActionTypes.put(11, StackRequestActionType.CRAFT_RECIPE_AUTO);
        this.stackRequestActionTypes.put(12, StackRequestActionType.CRAFT_CREATIVE);
        this.stackRequestActionTypes.put(13, StackRequestActionType.CRAFT_RECIPE_OPTIONAL);
        this.stackRequestActionTypes.put(14, StackRequestActionType.CRAFT_REPAIR_AND_DISENCHANT);
        this.stackRequestActionTypes.put(15, StackRequestActionType.CRAFT_LOOM);
        this.stackRequestActionTypes.put(16, StackRequestActionType.CRAFT_NON_IMPLEMENTED_DEPRECATED);
        this.stackRequestActionTypes.put(17, StackRequestActionType.CRAFT_RESULTS_DEPRECATED);
    }

    @Override
    protected StackRequestActionData readRequestActionData(ByteBuf byteBuf, StackRequestActionType type, BedrockSession session) {
        switch (type) {
            case CRAFT_REPAIR_AND_DISENCHANT: {
                return new CraftGrindstoneStackRequestActionData(VarInts.readUnsignedInt(byteBuf), VarInts.readInt(byteBuf));
            }
            case CRAFT_LOOM: {
                return new CraftLoomStackRequestActionData(this.readString(byteBuf));
            }
        }
        return super.readRequestActionData(byteBuf, type, session);
    }

    @Override
    protected void writeRequestActionData(ByteBuf byteBuf, StackRequestActionData action, BedrockSession session) {
        switch (action.getType()) {
            case CRAFT_REPAIR_AND_DISENCHANT: {
                CraftGrindstoneStackRequestActionData actionData = (CraftGrindstoneStackRequestActionData)action;
                VarInts.writeUnsignedInt(byteBuf, actionData.getRecipeNetworkId());
                VarInts.writeInt(byteBuf, actionData.getRepairCost());
                return;
            }
            case CRAFT_LOOM: {
                this.writeString(byteBuf, ((CraftLoomStackRequestActionData)action).getPatternId());
                return;
            }
        }
        super.writeRequestActionData(byteBuf, action, session);
    }
}

