/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v422;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.data.inventory.ItemStackRequest;
import com.nukkitx.protocol.bedrock.data.inventory.stackrequestactions.CraftRecipeOptionalStackRequestActionData;
import com.nukkitx.protocol.bedrock.data.inventory.stackrequestactions.StackRequestActionData;
import com.nukkitx.protocol.bedrock.data.inventory.stackrequestactions.StackRequestActionType;
import com.nukkitx.protocol.bedrock.v419.BedrockPacketHelper_v419;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;

public class BedrockPacketHelper_v422
extends BedrockPacketHelper_v419 {
    public static final BedrockPacketHelper_v422 INSTANCE = new BedrockPacketHelper_v422();

    @Override
    protected void registerStackActionRequestTypes() {
        this.stackRequestActionTypes.put(0, StackRequestActionType.TAKE);
        this.stackRequestActionTypes.put(1, StackRequestActionType.PLACE);
        this.stackRequestActionTypes.put(2, StackRequestActionType.SWAP);
        this.stackRequestActionTypes.put(3, StackRequestActionType.DROP);
        this.stackRequestActionTypes.put(4, StackRequestActionType.DESTROY);
        this.stackRequestActionTypes.put(5, StackRequestActionType.CONSUME);
        this.stackRequestActionTypes.put(6, StackRequestActionType.CREATE);
        this.stackRequestActionTypes.put(7, StackRequestActionType.LAB_TABLE_COMBINE);
        this.stackRequestActionTypes.put(8, StackRequestActionType.BEACON_PAYMENT);
        this.stackRequestActionTypes.put(9, StackRequestActionType.CRAFT_RECIPE);
        this.stackRequestActionTypes.put(10, StackRequestActionType.CRAFT_RECIPE_AUTO);
        this.stackRequestActionTypes.put(11, StackRequestActionType.CRAFT_CREATIVE);
        this.stackRequestActionTypes.put(12, StackRequestActionType.CRAFT_RECIPE_OPTIONAL);
        this.stackRequestActionTypes.put(13, StackRequestActionType.CRAFT_NON_IMPLEMENTED_DEPRECATED);
        this.stackRequestActionTypes.put(14, StackRequestActionType.CRAFT_RESULTS_DEPRECATED);
    }

    @Override
    public ItemStackRequest readItemStackRequest(ByteBuf buffer, BedrockSession session) {
        int requestId = VarInts.readInt(buffer);
        ArrayList actions = new ArrayList();
        this.readArray(buffer, actions, (ByteBuf byteBuf) -> {
            StackRequestActionType type = this.getStackRequestActionTypeFromId(byteBuf.readByte());
            return this.readRequestActionData((ByteBuf)byteBuf, type, session);
        });
        ArrayList filteredStrings = new ArrayList();
        this.readArray(buffer, filteredStrings, this::readString);
        return new ItemStackRequest(requestId, actions.toArray(new StackRequestActionData[0]), filteredStrings.toArray(new String[0]));
    }

    @Override
    public void writeItemStackRequest(ByteBuf buffer, BedrockSession session, ItemStackRequest request) {
        VarInts.writeInt(buffer, request.getRequestId());
        this.writeArray(buffer, request.getActions(), (ByteBuf byteBuf, T action) -> {
            StackRequestActionType type = action.getType();
            byteBuf.writeByte(this.getIdFromStackRequestActionType(type));
            this.writeRequestActionData((ByteBuf)byteBuf, (StackRequestActionData)action, session);
        });
        this.writeArray(buffer, request.getFilterStrings(), this::writeString);
    }

    @Override
    protected StackRequestActionData readRequestActionData(ByteBuf byteBuf, StackRequestActionType type, BedrockSession session) {
        StackRequestActionData action = type == StackRequestActionType.CRAFT_RECIPE_OPTIONAL ? new CraftRecipeOptionalStackRequestActionData(VarInts.readUnsignedInt(byteBuf), byteBuf.readIntLE()) : super.readRequestActionData(byteBuf, type, session);
        return action;
    }

    @Override
    protected void writeRequestActionData(ByteBuf byteBuf, StackRequestActionData action, BedrockSession session) {
        if (action.getType() == StackRequestActionType.CRAFT_RECIPE_OPTIONAL) {
            VarInts.writeUnsignedInt(byteBuf, ((CraftRecipeOptionalStackRequestActionData)action).getRecipeNetworkId());
            byteBuf.writeIntLE(((CraftRecipeOptionalStackRequestActionData)action).getFilteredStringIndex());
        } else {
            super.writeRequestActionData(byteBuf, action, session);
        }
    }
}

