/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v419.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.data.inventory.ContainerSlotType;
import com.nukkitx.protocol.bedrock.packet.ItemStackResponsePacket;
import com.nukkitx.protocol.bedrock.v407.serializer.ItemStackResponseSerializer_v407;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ItemStackResponseSerializer_v419
extends ItemStackResponseSerializer_v407 {
    public static final ItemStackResponseSerializer_v419 INSTANCE = new ItemStackResponseSerializer_v419();

    @Override
    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, ItemStackResponsePacket packet) {
        helper.writeArray(buffer, packet.getEntries(), (buf, response) -> {
            buf.writeByte(response.getResult().ordinal());
            VarInts.writeInt(buffer, response.getRequestId());
            if (response.getResult() != ItemStackResponsePacket.ResponseStatus.OK) {
                return;
            }
            helper.writeArray((ByteBuf)buf, response.getContainers(), (buf2, containerEntry) -> {
                buf2.writeByte(containerEntry.getContainer().ordinal());
                helper.writeArray((ByteBuf)buf2, containerEntry.getItems(), this::writeItemEntry);
            });
        });
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, ItemStackResponsePacket packet) {
        List<ItemStackResponsePacket.Response> entries = packet.getEntries();
        helper.readArray(buffer, entries, buf -> {
            ItemStackResponsePacket.ResponseStatus result = ItemStackResponsePacket.ResponseStatus.values()[buf.readByte()];
            int requestId = VarInts.readInt(buf);
            if (result != ItemStackResponsePacket.ResponseStatus.OK) {
                return new ItemStackResponsePacket.Response(result, requestId, Collections.emptyList());
            }
            ArrayList<ItemStackResponsePacket.ContainerEntry> containerEntries = new ArrayList<ItemStackResponsePacket.ContainerEntry>();
            helper.readArray((ByteBuf)buf, containerEntries, buf2 -> {
                ContainerSlotType container = ContainerSlotType.values()[buf2.readByte()];
                ArrayList<ItemStackResponsePacket.ItemEntry> itemEntries = new ArrayList<ItemStackResponsePacket.ItemEntry>();
                helper.readArray((ByteBuf)buf2, itemEntries, byteBuf -> this.readItemEntry((ByteBuf)buf2, helper));
                return new ItemStackResponsePacket.ContainerEntry(container, itemEntries);
            });
            return new ItemStackResponsePacket.Response(result, requestId, containerEntries);
        });
    }
}

