/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v388.serializer;

import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.data.command.CommandData;
import com.nukkitx.protocol.bedrock.data.command.CommandEnumConstraintData;
import com.nukkitx.protocol.bedrock.data.command.CommandEnumData;
import com.nukkitx.protocol.bedrock.data.command.CommandParam;
import com.nukkitx.protocol.bedrock.data.command.CommandParamData;
import com.nukkitx.protocol.bedrock.data.command.CommandParamOption;
import com.nukkitx.protocol.bedrock.data.command.CommandSymbolData;
import com.nukkitx.protocol.bedrock.packet.AvailableCommandsPacket;
import com.nukkitx.protocol.bedrock.v340.serializer.AvailableCommandsSerializer_v340;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class AvailableCommandsSerializer_v388
extends AvailableCommandsSerializer_v340 {
    public static final AvailableCommandsSerializer_v388 INSTANCE = new AvailableCommandsSerializer_v388();

    @Override
    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, AvailableCommandsPacket packet) {
        ObjectOpenHashSet enumValuesSet = new ObjectOpenHashSet();
        ObjectOpenHashSet postfixSet = new ObjectOpenHashSet();
        ObjectOpenHashSet enumsSet = new ObjectOpenHashSet();
        ObjectOpenHashSet softEnumsSet = new ObjectOpenHashSet();
        for (CommandData data : packet.getCommands()) {
            if (data.getAliases() != null) {
                Collections.addAll(enumValuesSet, data.getAliases().getValues());
                enumsSet.add(data.getAliases());
            }
            CommandParamData[][] commandParamDataArray = data.getOverloads();
            int n = commandParamDataArray.length;
            for (int i = 0; i < n; ++i) {
                CommandParamData[] overload;
                for (CommandParamData parameter : overload = commandParamDataArray[i]) {
                    String postfix;
                    CommandEnumData commandEnumData = parameter.getEnumData();
                    if (commandEnumData != null) {
                        if (commandEnumData.isSoft()) {
                            softEnumsSet.add(commandEnumData);
                        } else {
                            Collections.addAll(enumValuesSet, commandEnumData.getValues());
                            enumsSet.add(commandEnumData);
                        }
                    }
                    if ((postfix = parameter.getPostfix()) == null) continue;
                    postfixSet.add(postfix);
                }
            }
        }
        for (CommandEnumData enumData : packet.getConstraints().stream().map(CommandEnumConstraintData::getEnumData).collect(Collectors.toList())) {
            if (enumData.isSoft()) {
                softEnumsSet.add(enumData);
            } else {
                enumsSet.add(enumData);
            }
            enumValuesSet.addAll(Arrays.asList(enumData.getValues()));
        }
        ObjectArrayList enumValues = new ObjectArrayList((Collection)enumValuesSet);
        ObjectArrayList postFixes = new ObjectArrayList((Collection)postfixSet);
        ObjectArrayList enums = new ObjectArrayList((Collection)enumsSet);
        ObjectArrayList softEnums = new ObjectArrayList((Collection)softEnumsSet);
        helper.writeArray(buffer, enumValues, helper::writeString);
        helper.writeArray(buffer, postFixes, helper::writeString);
        this.writeEnums(buffer, helper, (List<String>)enumValues, (List<CommandEnumData>)enums);
        helper.writeArray(buffer, packet.getCommands(), (arg_0, arg_1) -> this.lambda$serialize$0(buffer, helper, (List)enums, (List)softEnums, (List)postFixes, arg_0, arg_1));
        helper.writeArray(buffer, softEnums, helper::writeCommandEnum);
        helper.writeArray(buffer, packet.getConstraints(), (arg_0, arg_1) -> AvailableCommandsSerializer_v388.lambda$serialize$1(helper, (List)enums, (List)enumValues, arg_0, arg_1));
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, AvailableCommandsPacket packet) {
        ObjectArrayList enumValues = new ObjectArrayList();
        ObjectArrayList postFixes = new ObjectArrayList();
        ObjectArrayList enums = new ObjectArrayList();
        ObjectArrayList commands = new ObjectArrayList();
        ObjectArrayList softEnums = new ObjectArrayList();
        helper.readArray(buffer, enumValues, helper::readString);
        helper.readArray(buffer, postFixes, helper::readString);
        this.readEnums(buffer, helper, (List<String>)enumValues, (List<CommandEnumData>)enums);
        helper.readArray(buffer, commands, this::readCommand);
        helper.readArray(buffer, softEnums, buf -> helper.readCommandEnum(buffer, true));
        for (CommandData.Builder command : commands) {
            int flags = command.getFlags();
            ObjectArrayList flagList = new ObjectArrayList();
            for (int i = 0; i < 6; ++i) {
                if ((flags & 1 << i) == 0) continue;
                flagList.add(FLAGS[i]);
            }
            int aliasesIndex = command.getAliases();
            CommandEnumData aliases = aliasesIndex == -1 ? null : (CommandEnumData)enums.get(aliasesIndex);
            CommandParamData.Builder[][] overloadBuilders = command.getOverloads();
            CommandParamData[][] overloads = new CommandParamData[overloadBuilders.length][];
            for (int i = 0; i < overloadBuilders.length; ++i) {
                overloads[i] = new CommandParamData[overloadBuilders[i].length];
                for (int i2 = 0; i2 < overloadBuilders[i].length; ++i2) {
                    CommandParamData.Builder param = overloadBuilders[i][i2];
                    String name = param.getName();
                    CommandSymbolData type = param.getType();
                    boolean optional = param.isOptional();
                    byte optionsByte = param.getOptions();
                    String postfix = null;
                    CommandEnumData enumData = null;
                    CommandParam commandParam = null;
                    if (type.isPostfix()) {
                        postfix = (String)postFixes.get(type.getValue());
                    } else if (type.isCommandEnum()) {
                        enumData = (CommandEnumData)enums.get(type.getValue());
                    } else if (type.isSoftEnum()) {
                        enumData = (CommandEnumData)softEnums.get(type.getValue());
                    } else {
                        commandParam = helper.getCommandParam(type.getValue());
                    }
                    ObjectArrayList options = new ObjectArrayList();
                    for (int idx = 0; idx < 8; ++idx) {
                        if ((optionsByte & 1 << idx) == 0) continue;
                        options.add(OPTIONS[idx]);
                    }
                    overloads[i][i2] = new CommandParamData(name, optional, enumData, commandParam, postfix, (List<CommandParamOption>)options);
                }
            }
            packet.getCommands().add(new CommandData(command.getName(), command.getDescription(), (List<CommandData.Flag>)flagList, command.getPermission(), aliases, overloads));
        }
        helper.readArray(buffer, packet.getConstraints(), arg_0 -> AvailableCommandsSerializer_v388.lambda$deserialize$3(helper, (List)enums, (List)enumValues, arg_0));
    }

    protected AvailableCommandsSerializer_v388() {
    }

    private static /* synthetic */ CommandEnumConstraintData lambda$deserialize$3(BedrockPacketHelper helper, List enums, List enumValues, ByteBuf buf) {
        return helper.readCommandEnumConstraints(buf, enums, enumValues);
    }

    private static /* synthetic */ void lambda$serialize$1(BedrockPacketHelper helper, List enums, List enumValues, ByteBuf buf, CommandEnumConstraintData constraint) {
        helper.writeCommandEnumConstraints(buf, constraint, enums, enumValues);
    }

    private /* synthetic */ void lambda$serialize$0(ByteBuf buffer, BedrockPacketHelper helper, List enums, List softEnums, List postFixes, ByteBuf buf, CommandData command) {
        this.writeCommand(buffer, helper, command, enums, softEnums, postFixes);
    }
}

