/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v332;

import com.nukkitx.nbt.NBTInputStream;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtUtils;
import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.data.LevelEventType;
import com.nukkitx.protocol.bedrock.data.command.CommandParam;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.v313.BedrockPacketHelper_v313;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.util.Objects;

public class BedrockPacketHelper_v332
extends BedrockPacketHelper_v313 {
    public static final BedrockPacketHelper INSTANCE = new BedrockPacketHelper_v332();

    @Override
    protected void registerCommandParams() {
        this.addCommandParam(1, CommandParam.INT);
        this.addCommandParam(2, CommandParam.FLOAT);
        this.addCommandParam(3, CommandParam.VALUE);
        this.addCommandParam(4, CommandParam.WILDCARD_INT);
        this.addCommandParam(5, CommandParam.OPERATOR);
        this.addCommandParam(6, CommandParam.TARGET);
        this.addCommandParam(7, CommandParam.WILDCARD_TARGET);
        this.addCommandParam(15, CommandParam.FILE_PATH);
        this.addCommandParam(19, CommandParam.INT_RANGE);
        this.addCommandParam(28, CommandParam.STRING);
        this.addCommandParam(30, CommandParam.POSITION);
        this.addCommandParam(33, CommandParam.MESSAGE);
        this.addCommandParam(35, CommandParam.TEXT);
        this.addCommandParam(38, CommandParam.JSON);
        this.addCommandParam(45, CommandParam.COMMAND);
    }

    @Override
    protected void registerEntityData() {
        super.registerEntityData();
        this.addEntityData(94, EntityData.AREA_EFFECT_CLOUD_DURATION);
        this.addEntityData(95, EntityData.AREA_EFFECT_CLOUD_SPAWN_TIME);
        this.addEntityData(96, EntityData.AREA_EFFECT_CLOUD_CHANGE_RATE);
        this.addEntityData(97, EntityData.AREA_EFFECT_CLOUD_CHANGE_ON_PICKUP);
        this.addEntityData(98, EntityData.AREA_EFFECT_CLOUD_COUNT);
    }

    @Override
    protected void registerLevelEvents() {
        super.registerLevelEvents();
        int block = 3500;
        this.addLevelEvent(12 + block, LevelEventType.CAULDRON_FILL_LAVA);
        this.addLevelEvent(13 + block, LevelEventType.CAULDRON_TAKE_LAVA);
    }

    @Override
    public ItemData readItem(ByteBuf buffer, BedrockSession session) {
        NbtMap compoundTag;
        int count;
        int damage;
        int id;
        block35: {
            id = VarInts.readInt(buffer);
            if (id == 0) {
                return ItemData.AIR;
            }
            int aux = VarInts.readInt(buffer);
            damage = aux >> 8;
            if (damage == Short.MAX_VALUE) {
                damage = -1;
            }
            count = aux & 0xFF;
            short nbtSize = buffer.readShortLE();
            compoundTag = null;
            if (nbtSize > 0) {
                try (NBTInputStream reader = NbtUtils.createReaderLE(new ByteBufInputStream(buffer.readSlice(nbtSize)));){
                    compoundTag = (NbtMap)reader.readTag();
                    break block35;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to load NBT data", e);
                }
            }
            if (nbtSize == -1) {
                short tagCount = buffer.readUnsignedByte();
                if (tagCount != 1) {
                    throw new IllegalArgumentException("Expected 1 tag but got " + tagCount);
                }
                try (NBTInputStream reader = NbtUtils.createNetworkReader(new ByteBufInputStream(buffer));){
                    compoundTag = (NbtMap)reader.readTag();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to load NBT data", e);
                }
            }
        }
        String[] canPlace = new String[VarInts.readInt(buffer)];
        for (int i = 0; i < canPlace.length; ++i) {
            canPlace[i] = this.readString(buffer);
        }
        String[] canBreak = new String[VarInts.readInt(buffer)];
        for (int i = 0; i < canBreak.length; ++i) {
            canBreak[i] = this.readString(buffer);
        }
        return ItemData.builder().id(id).damage(damage).count(count).tag(compoundTag).canPlace(canPlace).canBreak(canBreak).build();
    }

    @Override
    public void writeItem(ByteBuf buffer, ItemData item, BedrockSession session) {
        Objects.requireNonNull(item, "item is null!");
        int id = item.getId();
        if (id == 0) {
            buffer.writeByte(0);
            return;
        }
        VarInts.writeInt(buffer, id);
        int damage = item.getDamage();
        if (damage == -1) {
            damage = Short.MAX_VALUE;
        }
        VarInts.writeInt(buffer, damage << 8 | item.getCount() & 0xFF);
        if (item.getTag() != null) {
            buffer.writeShortLE(-1);
            buffer.writeByte(1);
            this.writeTag(buffer, item.getTag());
        } else {
            buffer.writeShortLE(0);
        }
        String[] canPlace = item.getCanPlace();
        VarInts.writeInt(buffer, canPlace.length);
        for (String aCanPlace : canPlace) {
            this.writeString(buffer, aCanPlace);
        }
        String[] canBreak = item.getCanBreak();
        VarInts.writeInt(buffer, canBreak.length);
        for (String aCanBreak : canBreak) {
            this.writeString(buffer, aCanBreak);
        }
    }

    protected BedrockPacketHelper_v332() {
    }
}

