/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v291.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.data.command.CommandData;
import com.nukkitx.protocol.bedrock.data.command.CommandEnumData;
import com.nukkitx.protocol.bedrock.data.command.CommandParam;
import com.nukkitx.protocol.bedrock.data.command.CommandParamData;
import com.nukkitx.protocol.bedrock.data.command.CommandParamOption;
import com.nukkitx.protocol.bedrock.data.command.CommandSymbolData;
import com.nukkitx.protocol.bedrock.packet.AvailableCommandsPacket;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.ObjIntConsumer;
import java.util.function.ToIntFunction;

public class AvailableCommandsSerializer_v291
implements BedrockPacketSerializer<AvailableCommandsPacket> {
    public static final AvailableCommandsSerializer_v291 INSTANCE = new AvailableCommandsSerializer_v291();
    protected static final ObjIntConsumer<ByteBuf> WRITE_BYTE = ByteBuf::writeByte;
    protected static final ObjIntConsumer<ByteBuf> WRITE_SHORT = ByteBuf::writeShortLE;
    protected static final ObjIntConsumer<ByteBuf> WRITE_INT = ByteBuf::writeIntLE;
    protected static final ToIntFunction<ByteBuf> READ_BYTE = ByteBuf::readUnsignedByte;
    protected static final ToIntFunction<ByteBuf> READ_SHORT = ByteBuf::readUnsignedShortLE;
    protected static final ToIntFunction<ByteBuf> READ_INT = ByteBuf::readIntLE;
    protected static final CommandData.Flag[] FLAGS = CommandData.Flag.values();
    protected static final CommandParamOption[] OPTIONS = CommandParamOption.values();

    @Override
    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, AvailableCommandsPacket packet) {
        ObjectOpenHashSet enumValuesSet = new ObjectOpenHashSet();
        ObjectOpenHashSet postfixSet = new ObjectOpenHashSet();
        ObjectOpenHashSet enumsSet = new ObjectOpenHashSet();
        ObjectOpenHashSet softEnumsSet = new ObjectOpenHashSet();
        for (CommandData data : packet.getCommands()) {
            if (data.getAliases() != null) {
                Collections.addAll(enumValuesSet, data.getAliases().getValues());
                enumsSet.add(data.getAliases());
            }
            CommandParamData[][] commandParamDataArray = data.getOverloads();
            int n = commandParamDataArray.length;
            for (int i = 0; i < n; ++i) {
                CommandParamData[] overload;
                for (CommandParamData parameter : overload = commandParamDataArray[i]) {
                    String postfix;
                    CommandEnumData commandEnumData = parameter.getEnumData();
                    if (commandEnumData != null) {
                        if (commandEnumData.isSoft()) {
                            softEnumsSet.add(commandEnumData);
                        } else {
                            Collections.addAll(enumValuesSet, commandEnumData.getValues());
                            enumsSet.add(commandEnumData);
                        }
                    }
                    if ((postfix = parameter.getPostfix()) == null) continue;
                    postfixSet.add(postfix);
                }
            }
        }
        ObjectArrayList enumValues = new ObjectArrayList((Collection)enumValuesSet);
        ObjectArrayList postFixes = new ObjectArrayList((Collection)postfixSet);
        ObjectArrayList enums = new ObjectArrayList((Collection)enumsSet);
        ObjectArrayList softEnums = new ObjectArrayList((Collection)softEnumsSet);
        helper.writeArray(buffer, enumValues, helper::writeString);
        helper.writeArray(buffer, postFixes, helper::writeString);
        this.writeEnums(buffer, helper, (List<String>)enumValues, (List<CommandEnumData>)enums);
        helper.writeArray(buffer, packet.getCommands(), (arg_0, arg_1) -> this.lambda$serialize$0(buffer, helper, (List)enums, (List)softEnums, (List)postFixes, arg_0, arg_1));
        helper.writeArray(buffer, softEnums, helper::writeCommandEnum);
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, AvailableCommandsPacket packet) {
        ObjectArrayList enumValues = new ObjectArrayList();
        ObjectArrayList postFixes = new ObjectArrayList();
        ObjectArrayList enums = new ObjectArrayList();
        ObjectArrayList commands = new ObjectArrayList();
        ObjectArrayList softEnums = new ObjectArrayList();
        helper.readArray(buffer, enumValues, helper::readString);
        helper.readArray(buffer, postFixes, helper::readString);
        this.readEnums(buffer, helper, (List<String>)enumValues, (List<CommandEnumData>)enums);
        helper.readArray(buffer, commands, this::readCommand);
        helper.readArray(buffer, softEnums, buf -> helper.readCommandEnum(buffer, true));
        for (CommandData.Builder command : commands) {
            int flags = command.getFlags();
            ObjectArrayList flagList = new ObjectArrayList();
            for (int i = 0; i < 6; ++i) {
                if ((flags & 1 << i) == 0) continue;
                flagList.add(FLAGS[i]);
            }
            int aliasesIndex = command.getAliases();
            CommandEnumData aliases = aliasesIndex == -1 ? null : (CommandEnumData)enums.get(aliasesIndex);
            CommandParamData.Builder[][] overloadBuilders = command.getOverloads();
            CommandParamData[][] overloads = new CommandParamData[overloadBuilders.length][];
            for (int i = 0; i < overloadBuilders.length; ++i) {
                overloads[i] = new CommandParamData[overloadBuilders[i].length];
                for (int i2 = 0; i2 < overloadBuilders[i].length; ++i2) {
                    CommandParamData.Builder param = overloadBuilders[i][i2];
                    String name = param.getName();
                    CommandSymbolData type = param.getType();
                    boolean optional = param.isOptional();
                    byte optionsByte = param.getOptions();
                    String postfix = null;
                    CommandEnumData enumData = null;
                    CommandParam commandParam = null;
                    if (type.isPostfix()) {
                        postfix = (String)postFixes.get(type.getValue());
                    } else if (type.isCommandEnum()) {
                        enumData = (CommandEnumData)enums.get(type.getValue());
                    } else if (type.isSoftEnum()) {
                        enumData = (CommandEnumData)softEnums.get(type.getValue());
                    } else {
                        commandParam = helper.getCommandParam(type.getValue());
                    }
                    ObjectArrayList options = new ObjectArrayList();
                    for (int idx = 0; idx < 8; ++idx) {
                        if ((optionsByte & 1 << idx) == 0) continue;
                        options.add(OPTIONS[idx]);
                    }
                    overloads[i][i2] = new CommandParamData(name, optional, enumData, commandParam, postfix, (List<CommandParamOption>)options);
                }
            }
            packet.getCommands().add(new CommandData(command.getName(), command.getDescription(), (List<CommandData.Flag>)flagList, command.getPermission(), aliases, overloads));
        }
    }

    protected void writeEnums(ByteBuf buffer, BedrockPacketHelper helper, List<String> values, List<CommandEnumData> enums) {
        int valuesSize = values.size();
        ObjIntConsumer<ByteBuf> indexWriter = valuesSize < 256 ? WRITE_BYTE : (valuesSize < 65536 ? WRITE_SHORT : WRITE_INT);
        helper.writeArray(buffer, enums, (buf, commandEnum) -> {
            helper.writeString((ByteBuf)buf, commandEnum.getName());
            VarInts.writeUnsignedInt(buffer, commandEnum.getValues().length);
            for (String value : commandEnum.getValues()) {
                int index = values.indexOf(value);
                Preconditions.checkArgument(index > -1, "Invalid enum value detected: " + value);
                indexWriter.accept((ByteBuf)buf, index);
            }
        });
    }

    protected void readEnums(ByteBuf buffer, BedrockPacketHelper helper, List<String> values, List<CommandEnumData> enums) {
        int valuesSize = values.size();
        ToIntFunction<ByteBuf> indexReader = valuesSize < 256 ? READ_BYTE : (valuesSize < 65536 ? READ_SHORT : READ_INT);
        helper.readArray(buffer, enums, buf -> {
            String name = helper.readString((ByteBuf)buf);
            int length = VarInts.readUnsignedInt(buffer);
            String[] enumValues = new String[length];
            for (int i = 0; i < length; ++i) {
                enumValues[i] = (String)values.get(indexReader.applyAsInt((ByteBuf)buf));
            }
            return new CommandEnumData(name, enumValues, false);
        });
    }

    protected void writeCommand(ByteBuf buffer, BedrockPacketHelper helper, CommandData commandData, List<CommandEnumData> enums, List<CommandEnumData> softEnums, List<String> postFixes) {
        helper.writeString(buffer, commandData.getName());
        helper.writeString(buffer, commandData.getDescription());
        int flags = 0;
        for (CommandData.Flag flag : commandData.getFlags()) {
            flags = (byte)(flags | 1 << flag.ordinal());
        }
        buffer.writeByte(flags);
        buffer.writeByte(commandData.getPermission());
        CommandEnumData aliases = commandData.getAliases();
        buffer.writeIntLE(enums.indexOf(aliases));
        CommandParamData[][] overloads = commandData.getOverloads();
        VarInts.writeUnsignedInt(buffer, overloads.length);
        for (CommandParamData[] overload : overloads) {
            VarInts.writeUnsignedInt(buffer, overload.length);
            for (CommandParamData param : overload) {
                this.writeParameter(buffer, helper, param, enums, softEnums, postFixes);
            }
        }
    }

    protected CommandData.Builder readCommand(ByteBuf buffer, BedrockPacketHelper helper) {
        String name = helper.readString(buffer);
        String description = helper.readString(buffer);
        byte flags = buffer.readByte();
        byte permissions = buffer.readByte();
        int aliasesIndex = buffer.readIntLE();
        CommandParamData.Builder[][] overloads = new CommandParamData.Builder[VarInts.readUnsignedInt(buffer)][];
        for (int i = 0; i < overloads.length; ++i) {
            overloads[i] = new CommandParamData.Builder[VarInts.readUnsignedInt(buffer)];
            for (int i2 = 0; i2 < overloads[i].length; ++i2) {
                overloads[i][i2] = this.readParameter(buffer, helper);
            }
        }
        return new CommandData.Builder(name, description, flags, permissions, aliasesIndex, overloads);
    }

    protected void writeParameter(ByteBuf buffer, BedrockPacketHelper helper, CommandParamData param, List<CommandEnumData> enums, List<CommandEnumData> softEnums, List<String> postFixes) {
        int index;
        helper.writeString(buffer, param.getName());
        boolean postfix = false;
        boolean enumData = false;
        boolean softEnum = false;
        if (param.getPostfix() != null) {
            postfix = true;
            index = postFixes.indexOf(param.getPostfix());
        } else if (param.getEnumData() != null) {
            if (param.getEnumData().isSoft()) {
                softEnum = true;
                index = softEnums.indexOf(param.getEnumData());
            } else {
                enumData = true;
                index = enums.indexOf(param.getEnumData());
            }
        } else if (param.getType() != null) {
            index = param.getType().getValue(helper);
        } else {
            throw new IllegalStateException("No param type specified: " + param);
        }
        CommandSymbolData type = new CommandSymbolData(index, enumData, softEnum, postfix);
        buffer.writeIntLE(type.serialize());
        buffer.writeBoolean(param.isOptional());
    }

    protected CommandParamData.Builder readParameter(ByteBuf buffer, BedrockPacketHelper helper) {
        return new CommandParamData.Builder(helper.readString(buffer), CommandSymbolData.deserialize(buffer.readIntLE()), buffer.readBoolean(), 0);
    }

    protected AvailableCommandsSerializer_v291() {
    }

    private /* synthetic */ void lambda$serialize$0(ByteBuf buffer, BedrockPacketHelper helper, List enums, List softEnums, List postFixes, ByteBuf buf, CommandData command) {
        this.writeCommand(buffer, helper, command, enums, softEnums, postFixes);
    }
}

