/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.packet;

import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockPacketType;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class UpdateBlockPacket
extends BedrockPacket {
    public static final Set<Flag> FLAG_ALL = Collections.unmodifiableSet(EnumSet.of(Flag.NEIGHBORS, Flag.NETWORK));
    public static final Set<Flag> FLAG_ALL_PRIORITY = Collections.unmodifiableSet(EnumSet.of(Flag.NEIGHBORS, Flag.NETWORK, Flag.PRIORITY));
    final Set<Flag> flags = EnumSet.noneOf(Flag.class);
    Vector3i blockPosition;
    int runtimeId;
    int dataLayer;

    @Override
    public boolean handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.UPDATE_BLOCK;
    }

    public Set<Flag> getFlags() {
        return this.flags;
    }

    public Vector3i getBlockPosition() {
        return this.blockPosition;
    }

    public int getRuntimeId() {
        return this.runtimeId;
    }

    public int getDataLayer() {
        return this.dataLayer;
    }

    public void setBlockPosition(Vector3i blockPosition) {
        this.blockPosition = blockPosition;
    }

    public void setRuntimeId(int runtimeId) {
        this.runtimeId = runtimeId;
    }

    public void setDataLayer(int dataLayer) {
        this.dataLayer = dataLayer;
    }

    @Override
    public String toString() {
        return "UpdateBlockPacket(flags=" + this.getFlags() + ", blockPosition=" + this.getBlockPosition() + ", runtimeId=" + this.getRuntimeId() + ", dataLayer=" + this.getDataLayer() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateBlockPacket)) {
            return false;
        }
        UpdateBlockPacket other = (UpdateBlockPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<Flag> this$flags = this.flags;
        Set<Flag> other$flags = other.flags;
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        Vector3i this$blockPosition = this.blockPosition;
        Vector3i other$blockPosition = other.blockPosition;
        if (this$blockPosition == null ? other$blockPosition != null : !((Object)this$blockPosition).equals(other$blockPosition)) {
            return false;
        }
        if (this.runtimeId != other.runtimeId) {
            return false;
        }
        return this.dataLayer == other.dataLayer;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UpdateBlockPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<Flag> $flags = this.flags;
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        Vector3i $blockPosition = this.blockPosition;
        result = result * 59 + ($blockPosition == null ? 43 : ((Object)$blockPosition).hashCode());
        result = result * 59 + this.runtimeId;
        result = result * 59 + this.dataLayer;
        return result;
    }

    public static enum Flag {
        NEIGHBORS,
        NETWORK,
        NO_GRAPHIC,
        UNUSED,
        PRIORITY;

    }
}

