/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.handler;

import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.handler.BatchHandler;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collection;

public class DefaultBatchHandler
implements BatchHandler {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(DefaultBatchHandler.class);
    public static final DefaultBatchHandler INSTANCE = new DefaultBatchHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(BedrockSession session, ByteBuf compressed, Collection<BedrockPacket> packets) {
        for (BedrockPacket packet : packets) {
            if (session.isLogging() && log.isTraceEnabled()) {
                log.trace("Inbound {}: {}", (Object)session.getAddress(), (Object)packet);
            }
            BedrockPacketHandler handler = session.getPacketHandler();
            boolean release = true;
            try {
                if (handler != null && packet.handle(handler)) {
                    release = false;
                    continue;
                }
                log.debug("Unhandled packet for {}: {}", (Object)session.getAddress(), (Object)packet);
            }
            finally {
                if (!release) continue;
                ReferenceCountUtil.release(packet);
            }
        }
    }

    private DefaultBatchHandler() {
    }
}

