/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data.entity;

import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.util.Int2ObjectBiMap;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class EntityFlags {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(EntityFlags.class);
    private final Set<EntityFlag> flags = EnumSet.noneOf(EntityFlag.class);

    public boolean setFlag(@Nonnull EntityFlag flag, boolean value) {
        Preconditions.checkNotNull(flag, "flag");
        boolean oldValue = this.flags.contains((Object)flag);
        if (oldValue != value) {
            if (value) {
                this.flags.add(flag);
            } else {
                this.flags.remove((Object)flag);
            }
            return true;
        }
        return false;
    }

    public boolean getFlag(@Nonnull EntityFlag flag) {
        Preconditions.checkNotNull(flag, "flag");
        return this.flags.contains((Object)flag);
    }

    public long get(int index, Int2ObjectBiMap<EntityFlag> flagMappings) {
        long value = 0L;
        int lower = index * 64;
        int upper = lower + 64;
        for (EntityFlag flag : this.flags) {
            int flagIndex = flagMappings.get(flag);
            if (flagIndex < lower || flagIndex >= upper) continue;
            value |= 1L << (flagIndex & 0x3F);
        }
        return value;
    }

    public void set(long value, int index, Int2ObjectBiMap<EntityFlag> flagMappings) {
        int lower = index * 64;
        int upper = lower + 64;
        for (int i = lower; i < upper; ++i) {
            int idx = i & 0x3F;
            if ((value & 1L << idx) == 0L) continue;
            EntityFlag flag = flagMappings.get(i);
            if (flag != null) {
                this.flags.add(flag);
                continue;
            }
            log.debug("Unknown entity flag index {} detected", (Object)i);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityFlags)) {
            return false;
        }
        EntityFlags that = (EntityFlags)o;
        return this.flags.equals(that.flags);
    }

    public int hashCode() {
        return this.flags.hashCode();
    }

    public void merge(EntityFlags flags) {
        this.flags.addAll(flags.flags);
    }

    public EntityFlags copy() {
        EntityFlags flags = new EntityFlags();
        flags.flags.addAll(this.flags);
        return flags;
    }

    public String toString() {
        return "EntityFlags(flags=" + this.flags + ")";
    }
}

