/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock;

import com.nukkitx.network.raknet.RakNetSession;
import com.nukkitx.protocol.MinecraftServerSession;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.packet.DisconnectPacket;
import com.nukkitx.protocol.bedrock.wrapper.BedrockWrapperSerializer;
import io.netty.channel.EventLoop;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public class BedrockServerSession
extends BedrockSession
implements MinecraftServerSession<BedrockPacket> {
    public BedrockServerSession(RakNetSession connection, EventLoop eventLoop, BedrockWrapperSerializer serializer) {
        super(connection, eventLoop, serializer);
    }

    @Override
    public void disconnect() {
        this.disconnect(null, true);
    }

    @Override
    public void disconnect(@Nullable String reason) {
        this.disconnect(reason, false);
    }

    public void disconnect(@Nullable String reason, boolean hideReason) {
        EventLoop eventLoop = this.getEventLoop();
        if (eventLoop.inEventLoop()) {
            this.disconnect0(reason, hideReason);
        } else {
            eventLoop.submit(() -> this.disconnect0(reason, hideReason));
        }
    }

    public CompletableFuture<Void> disconnectFuture(@Nullable String reason, boolean hideReason) {
        this.checkForClosed();
        EventLoop eventLoop = this.getEventLoop();
        if (eventLoop.inEventLoop()) {
            this.disconnect0(reason, hideReason);
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        eventLoop.submit(() -> {
            this.disconnect0(reason, hideReason);
            future.complete(null);
        });
        return future;
    }

    private void disconnect0(@Nullable String reason, boolean hideReason) {
        DisconnectPacket packet = new DisconnectPacket();
        if (reason == null || hideReason) {
            packet.setMessageSkipped(true);
            reason = "disconnect.disconnected";
        }
        packet.setKickMessage(reason);
        this.sendPacketImmediately(packet);
    }
}

